/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class ReflectionDBObject
implements DBObject {
    private static final Map<Class, JavaWrapper> _wrappers = Collections.synchronizedMap(new HashMap());
    private static final Set<String> IGNORE_FIELDS = new HashSet<String>();

    public static JavaWrapper getWrapperIfReflectionObject(Class c) {
        if (ReflectionDBObject.class.isAssignableFrom(c)) {
            return ReflectionDBObject.getWrapper(c);
        }
        return null;
    }

    public static JavaWrapper getWrapper(Class c) {
        JavaWrapper w = _wrappers.get(c);
        if (w == null) {
            w = new JavaWrapper(c);
            _wrappers.put(c, w);
        }
        return w;
    }

    static {
        IGNORE_FIELDS.add("Int");
    }

    static class FieldInfo {
        final String _name;
        final Class _class;
        Method _getter;
        Method _setter;

        FieldInfo(String name, Class c) {
            this._name = name;
            this._class = c;
        }

        boolean ok() {
            return this._getter != null && this._setter != null;
        }
    }

    public static class JavaWrapper {
        final Class _class;
        final String _name;
        final Map<String, FieldInfo> _fields;
        final Set<String> _keys;

        JavaWrapper(Class c) {
            this._class = c;
            this._name = c.getName();
            this._fields = new TreeMap<String, FieldInfo>();
            for (Method m : c.getMethods()) {
                String name;
                if (!m.getName().startsWith("get") && !m.getName().startsWith("set") || (name = m.getName().substring(3)).length() == 0 || IGNORE_FIELDS.contains(name)) continue;
                Class<?> type = m.getName().startsWith("get") ? m.getReturnType() : m.getParameterTypes()[0];
                FieldInfo fi = this._fields.get(name);
                if (fi == null) {
                    fi = new FieldInfo(name, type);
                    this._fields.put(name, fi);
                }
                if (m.getName().startsWith("get")) {
                    fi._getter = m;
                    continue;
                }
                fi._setter = m;
            }
            HashSet<String> names = new HashSet<String>(this._fields.keySet());
            for (String name : names) {
                if (this._fields.get(name).ok()) continue;
                this._fields.remove(name);
            }
            this._keys = Collections.unmodifiableSet(this._fields.keySet());
        }

        Class getInternalClass(String path) {
            FieldInfo fi;
            String cur = path;
            String next2 = null;
            int idx = path.indexOf(".");
            if (idx >= 0) {
                cur = path.substring(0, idx);
                next2 = path.substring(idx + 1);
            }
            if ((fi = this._fields.get(cur)) == null) {
                return null;
            }
            if (next2 == null) {
                return fi._class;
            }
            JavaWrapper w = ReflectionDBObject.getWrapperIfReflectionObject(fi._class);
            if (w == null) {
                return null;
            }
            return w.getInternalClass(next2);
        }
    }
}

