/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.faraday.FaradayResources;
import edu.colorado.phet.faraday.model.Electron;
import edu.colorado.phet.faraday.model.ElectronPathDescriptor;
import java.awt.Component;
import java.awt.image.BufferedImage;

public class ElectronGraphic
extends PhetImageGraphic
implements SimpleObserver {
    private Electron _electronModel;
    private CompositePhetGraphic _parent;
    private BufferedImage _foregroundImage;
    private BufferedImage _backgroundImage;

    public ElectronGraphic(Component component, CompositePhetGraphic compositePhetGraphic, Electron electron) {
        super(component);
        assert (component != null);
        assert (compositePhetGraphic != null);
        assert (electron != null);
        this._electronModel = electron;
        this._electronModel.addObserver(this);
        this._foregroundImage = FaradayResources.getImage("electron_foreground.png");
        this._backgroundImage = FaradayResources.getImage("electron_background.png");
        this.setImage(this._foregroundImage);
        int n = this.getImage().getWidth() / 2;
        int n2 = this.getImage().getHeight() / 2;
        this.setRegistrationPoint(n, n2);
        this.update();
    }

    public void update() {
        this.setVisible(this._electronModel.isEnabled());
        if (this.isVisible()) {
            ElectronPathDescriptor electronPathDescriptor = this._electronModel.getPathDescriptor();
            CompositePhetGraphic compositePhetGraphic = electronPathDescriptor.getParent();
            if (compositePhetGraphic != this._parent) {
                if (this._parent != null) {
                    this._parent.removeGraphic(this);
                }
                compositePhetGraphic.addGraphic(this);
                this._parent = compositePhetGraphic;
                if (electronPathDescriptor.getLayer() == 1) {
                    this.setImage(this._backgroundImage);
                } else {
                    this.setImage(this._foregroundImage);
                }
            }
            int n = (int)this._electronModel.getX();
            int n2 = (int)this._electronModel.getY();
            this.setLocation(n, n2);
            this.repaint();
        }
    }
}

