/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.faraday.util.QuadBezierSpline;

public class ElectronPathDescriptor {
    private final QuadBezierSpline _curve;
    private final CompositePhetGraphic _parent;
    private final int _layer;
    private final double _pathScale;

    public ElectronPathDescriptor(QuadBezierSpline quadBezierSpline, CompositePhetGraphic compositePhetGraphic, int n, double d) {
        assert (quadBezierSpline != null);
        assert (compositePhetGraphic != null);
        assert (n == 0 || n == 1);
        assert (d > 0.0);
        this._curve = quadBezierSpline;
        this._parent = compositePhetGraphic;
        this._layer = n;
        this._pathScale = d;
    }

    public ElectronPathDescriptor(QuadBezierSpline quadBezierSpline, CompositePhetGraphic compositePhetGraphic, int n) {
        this(quadBezierSpline, compositePhetGraphic, n, 1.0);
    }

    public QuadBezierSpline getCurve() {
        return this._curve;
    }

    public CompositePhetGraphic getParent() {
        return this._parent;
    }

    public int getLayer() {
        return this._layer;
    }

    public double getPathScale() {
        return this._pathScale;
    }
}

