/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.faraday.model.AbstractMagnet;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class CoilMagnet
extends AbstractMagnet {
    private Rectangle2D _modelShape = new Rectangle2D.Double();
    private double _maxStrengthOutside = 0.0;

    public Shape getShape() {
        return this._modelShape;
    }

    public boolean isInside(Point2D point2D) {
        return this._modelShape.contains(point2D);
    }

    protected void notifySelf() {
        double d = this.getWidth();
        double d2 = this.getHeight();
        this._modelShape.setFrame(-d / 2.0, -d2 / 2.0, d, d2);
    }

    protected Vector2D getBFieldRelative(Point2D point2D, Vector2D vector2D) {
        assert (point2D != null);
        assert (vector2D != null);
        assert (this.getWidth() == this.getHeight());
        if (this.isInside(point2D)) {
            this.getBFieldInside(point2D, vector2D);
        } else {
            this.getBFieldOutside(point2D, vector2D);
        }
        return vector2D;
    }

    private void getBFieldInside(Point2D point2D, Vector2D vector2D) {
        assert (point2D != null);
        assert (vector2D != null);
        vector2D.setMagnitudeAndAngle(this.getStrength(), 0.0);
    }

    private void getBFieldOutside(Point2D point2D, Vector2D vector2D) {
        assert (point2D != null);
        assert (vector2D != null);
        assert (this.getWidth() == this.getHeight());
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = this.getWidth() / 2.0;
        double d5 = 3.0;
        double d6 = this.getStrength() * Math.pow(d4, d5) / 2.0;
        double d7 = d6 / Math.pow(d3, d5);
        double d8 = d / d3;
        double d9 = d2 / d3;
        double d10 = d7 * (3.0 * d8 * d8 - 1.0);
        double d11 = d7 * (3.0 * d8 * d9);
        vector2D.setComponents(d10, d11);
        if (vector2D.getMagnitude() > this._maxStrengthOutside) {
            this._maxStrengthOutside = vector2D.getMagnitude();
        }
    }
}

