/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.control.dialog;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.panel.FaradayPanel;
import edu.colorado.phet.faraday.module.ICompassGridModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GridControlsDialog
extends PaintImmediateDialog
implements ActionListener,
ChangeListener {
    private PhetApplication _app;
    private JSlider _spacingSlider;
    private JSlider _needleSizeSlider;
    private JLabel _gridSpacingValue;
    private JLabel _needleSizeValue;
    private JButton _okButton;
    private JButton _cancelButton;
    private int _xSpacing;
    private int _ySpacing;
    private Dimension _needleSize;

    public GridControlsDialog(PhetApplication phetApplication) {
        super(phetApplication.getPhetFrame());
        this._app = phetApplication;
        super.setTitle(FaradayStrings.TITLE_GRID_CONTROLS);
        super.setModal(false);
        super.setResizable(false);
        this.initValues();
        this.createUI(phetApplication.getPhetFrame());
    }

    private void initValues() {
        Module module = this._app.getActiveModule();
        if (!(module instanceof ICompassGridModule)) {
            int n = this._app.numModules();
            for (int i = 0; i < n && !((module = this._app.getModule(i)) instanceof ICompassGridModule); ++i) {
                module = null;
            }
        }
        assert (module != null);
        ICompassGridModule iCompassGridModule = (ICompassGridModule)((Object)module);
        this._xSpacing = iCompassGridModule.getGridXSpacing();
        this._ySpacing = iCompassGridModule.getGridYSpacing();
        this._needleSize = iCompassGridModule.getGridNeedleSize();
    }

    private void createUI(Frame frame) {
        JPanel jPanel = this.createInputPanel();
        JPanel jPanel2 = this.createActionsPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JSeparator(), "North");
        jPanel3.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(new EmptyBorder(10, 10, 0, 10));
        jPanel4.add((Component)jPanel, "Center");
        jPanel4.add((Component)jPanel3, "South");
        this.getContentPane().add(jPanel4);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(frame);
    }

    private JPanel createInputPanel() {
        JLabel jLabel = new JLabel(FaradayStrings.LABEL_GRID_CONTROLS_WARNING);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel(FaradayStrings.LABEL_NEEDLE_SPACING);
        this._spacingSlider = new JSlider();
        this._spacingSlider.setMinimum(35);
        this._spacingSlider.setMaximum(100);
        this._spacingSlider.setValue(this._xSpacing);
        this._spacingSlider.setPreferredSize(FaradayPanel.SLIDER_SIZE);
        this._spacingSlider.setMaximumSize(FaradayPanel.SLIDER_SIZE);
        this._spacingSlider.setMinimumSize(FaradayPanel.SLIDER_SIZE);
        this._gridSpacingValue = new JLabel(String.valueOf(this._xSpacing));
        JLabel jLabel3 = new JLabel(FaradayStrings.LABEL_NEEDLE_SIZE);
        this._needleSizeSlider = new JSlider();
        this._needleSizeSlider.setMinimum(20);
        this._needleSizeSlider.setMaximum(60);
        this._needleSizeSlider.setValue(this._needleSize.width);
        this._needleSizeSlider.setPreferredSize(FaradayPanel.SLIDER_SIZE);
        this._needleSizeSlider.setMaximumSize(FaradayPanel.SLIDER_SIZE);
        this._needleSizeSlider.setMinimumSize(FaradayPanel.SLIDER_SIZE);
        Object object = String.valueOf(this._needleSize.width) + "x" + String.valueOf(this._needleSize.height);
        this._needleSizeValue = new JLabel((String)object);
        this._spacingSlider.addChangeListener(this);
        this._needleSizeSlider.addChangeListener(this);
        object = new JPanel();
        Serializable serializable = new EasyGridBagLayout((JPanel)object);
        ((Container)object).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)object).setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        ((EasyGridBagLayout)serializable).addAnchoredComponent(jLabel2, n, 0, 13);
        ((EasyGridBagLayout)serializable).addAnchoredComponent(this._spacingSlider, n, 1, 17);
        ((EasyGridBagLayout)serializable).addAnchoredComponent(this._gridSpacingValue, n, 2, 17);
        ((EasyGridBagLayout)serializable).addAnchoredComponent(jLabel3, ++n, 0, 13);
        ((EasyGridBagLayout)serializable).addAnchoredComponent(this._needleSizeSlider, n, 1, 17);
        ((EasyGridBagLayout)serializable).addAnchoredComponent(this._needleSizeValue, n, 2, 17);
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BorderLayout());
        ((Container)serializable).add(jPanel, "North");
        ((Container)serializable).add((Component)object, "Center");
        return serializable;
    }

    private JPanel createActionsPanel() {
        this._okButton = new JButton(FaradayStrings.BUTTON_OK);
        this._okButton.addActionListener(this);
        this._cancelButton = new JButton(FaradayStrings.BUTTON_CANCEL);
        this._cancelButton.addActionListener(this);
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        jPanel.add(this._okButton);
        jPanel.add(this._cancelButton);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jPanel);
        return jPanel2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._okButton) {
            this.dispose();
        } else if (actionEvent.getSource() == this._cancelButton) {
            this.revert();
            this.dispose();
        }
    }

    public void revert() {
        this.setAllGrids(this._xSpacing, this._ySpacing, this._needleSize);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = this._spacingSlider.getValue();
        int n2 = this._needleSizeSlider.getValue();
        int n3 = (int)((double)n2 / 3.5714285714285716);
        Dimension dimension = new Dimension(n2, n3);
        this._gridSpacingValue.setText(String.valueOf(n));
        this._needleSizeValue.setText(String.valueOf(n2) + "x" + String.valueOf(n3));
        this.setAllGrids(n, n, dimension);
    }

    private void setAllGrids(int n, int n2, Dimension dimension) {
        int n3 = this._app.numModules();
        for (int i = 0; i < n3; ++i) {
            Module module = this._app.getModule(i);
            if (!(module instanceof ICompassGridModule)) continue;
            ((ICompassGridModule)((Object)module)).setGridSpacing(n, n2);
            ((ICompassGridModule)((Object)module)).setGridNeedleSize(dimension);
        }
    }
}

