/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.electrichockey;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.electrichockey.BarrierList;
import edu.colorado.phet.electrichockey.Charge;
import edu.colorado.phet.electrichockey.ElectricHockeySimulationPanel;
import edu.colorado.phet.electrichockey.ElectricHockeyStrings;
import edu.colorado.phet.electrichockey.Force;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PlayingField
extends JPanel {
    private ElectricHockeySimulationPanel electricHockeySimulationPanel;
    private int fieldWidth;
    private int fieldHeight;
    private Rectangle plusBag;
    private Rectangle minusBag;
    private Rectangle chargeBag;
    Rectangle goal;
    private int bagWidth;
    private Color fieldColor;
    private JLabel bagLabel;
    private Font fieldFont;
    private Color barrierColor;
    private Graphics2D g2D;
    private Charge grabbedCharge;
    private Force grabbedChargeForce;
    private boolean newChargeIsGrabbed;
    private boolean oldChargeIsGrabbed;
    private int grabbedChargeIndex;
    private int barrierState;
    private BufferedImage fieldLinesImage;
    private Stroke pathStroke = new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{10.0f, 5.0f}, 0.0f);
    private Color pathColor = Color.red;
    private boolean debugRegions = false;

    public PlayingField(int n, int n2, ElectricHockeySimulationPanel electricHockeySimulationPanel) {
        this.electricHockeySimulationPanel = electricHockeySimulationPanel;
        this.fieldWidth = n;
        this.fieldHeight = n2;
        this.setSize(n, n2);
        this.fieldLinesImage = new BufferedImage(n, n2, 1);
        this.fieldColor = new Color(230, 235, 255);
        this.setBackground(this.fieldColor);
        this.barrierColor = new Color(100, 100, 250);
        this.fieldFont = new PhetFont(50);
        this.bagWidth = n / 15;
        this.plusBag = new Rectangle(8 * n / 10, 10, this.bagWidth, this.bagWidth);
        this.minusBag = new Rectangle(8 * n / 10 + this.bagWidth, 10, this.bagWidth, this.bagWidth);
        this.chargeBag = this.plusBag.union(this.minusBag);
        this.bagLabel = new JLabel("edu.colorado.phet.ehockey.Charge Bags");
        this.bagLabel.setBackground(Color.white);
        this.newChargeIsGrabbed = false;
        this.oldChargeIsGrabbed = false;
        this.barrierState = electricHockeySimulationPanel.getControlPanel().getLevelState();
        this.goal = new Rectangle(89 * n / 100, n2 / 2 - 30, 13, 60);
        this.addMouseListener(new FieldMouseListener());
        this.addMouseMotionListener(new FieldMouseMotionListener());
        this.repaint();
    }

    public void updateBufferedImage() {
        Graphics2D graphics2D = (Graphics2D)this.fieldLinesImage.getGraphics();
        this.electricHockeySimulationPanel.getFieldGrid().paint(graphics2D);
    }

    public void paintAgain() {
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        super.paintComponent(graphics);
        this.g2D = (Graphics2D)graphics;
        if (this.electricHockeySimulationPanel.isAntialias()) {
            this.g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.electricHockeySimulationPanel.getControlPanel().getShowField() && this.electricHockeySimulationPanel.getModel().getChargeListSize() != 0) {
            this.g2D.drawRenderedImage(this.fieldLinesImage, new AffineTransform());
        }
        this.g2D.drawImage(this.electricHockeySimulationPanel.getPlusBag(), this.plusBag.x, this.plusBag.y, this);
        this.g2D.setColor(Color.black);
        this.g2D.drawRect(this.plusBag.x, this.plusBag.y, this.plusBag.width, this.plusBag.height);
        this.g2D.drawImage(this.electricHockeySimulationPanel.getMinusBag(), this.minusBag.x, this.minusBag.y, this);
        this.g2D.setColor(Color.black);
        this.g2D.drawRect(this.minusBag.x, this.minusBag.y, this.minusBag.width, this.minusBag.height);
        if (this.newChargeIsGrabbed) {
            this.grabbedCharge.paint(this.g2D);
            this.grabbedChargeForce.paint(this.g2D);
        }
        this.g2D.setColor(this.barrierColor);
        this.barrierState = this.electricHockeySimulationPanel.getControlPanel().getLevelState();
        for (n2 = 0; n2 < BarrierList.currentRectArray[this.barrierState].length; ++n2) {
            int n3 = BarrierList.currentRectArray[this.barrierState][n2].x;
            int n4 = BarrierList.currentRectArray[this.barrierState][n2].y;
            n = BarrierList.currentRectArray[this.barrierState][n2].width;
            int n5 = BarrierList.currentRectArray[this.barrierState][n2].height;
            this.g2D.fill3DRect(n3, n4, n, n5, true);
        }
        if (this.debugRegions) {
            this.g2D.setColor(Color.red);
            this.g2D.fillRect(this.goal.x, this.goal.y, this.goal.width, this.goal.height);
        }
        for (n2 = 0; n2 < this.electricHockeySimulationPanel.getModel().getChargeListSize(); ++n2) {
            Charge charge = this.electricHockeySimulationPanel.getModel().getChargeAt(n2);
            if (charge.getSign() == -1) {
                this.g2D.drawImage(this.electricHockeySimulationPanel.getMinusDisk(), charge.getPosition().x - charge.radius, charge.getPosition().y - charge.radius, this);
            } else if (charge.getSign() == 1) {
                this.g2D.drawImage(this.electricHockeySimulationPanel.getPlusDisk(), charge.getPosition().x - charge.radius, charge.getPosition().y - charge.radius, this);
            }
            Force force = this.electricHockeySimulationPanel.getModel().getForceAt(n2);
            force.paint(this.g2D);
        }
        Charge charge = this.electricHockeySimulationPanel.getModel().getPuck();
        if (charge.getSign() == 1) {
            this.g2D.drawImage(this.electricHockeySimulationPanel.getPositivePuckImage(), charge.getPosition().x - charge.radius, charge.getPosition().y - charge.radius, this);
        } else {
            this.g2D.drawImage(this.electricHockeySimulationPanel.getNegativePuckImage(), charge.getPosition().x - charge.radius, charge.getPosition().y - charge.radius, this);
        }
        this.g2D.setFont(this.fieldFont);
        if (this.electricHockeySimulationPanel.getModel().getGoalState()) {
            this.g2D.setColor(new Color(0, 125, 0));
            this.g2D.setFont(new PhetFont(110));
            this.g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g2D.drawString(ElectricHockeyStrings.getString("HockeyPlayingField.Goal"), 3 * this.fieldWidth / 10, this.fieldHeight / 5);
        }
        if (this.electricHockeySimulationPanel.getModel().getCollisionState() && !this.electricHockeySimulationPanel.getModel().getGoalState()) {
            this.g2D.setColor(Color.red);
            this.g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g2D.drawString(ElectricHockeyStrings.getString("HockeyPlayingField.Collision"), 2 * this.fieldWidth / 5, this.fieldHeight / 10);
        }
        if (this.electricHockeySimulationPanel.getControlPanel().getTraceState()) {
            this.g2D.setColor(Color.black);
            Stroke stroke = this.g2D.getStroke();
            this.g2D.setStroke(this.pathStroke);
            this.g2D.setColor(this.pathColor);
            this.g2D.draw(this.electricHockeySimulationPanel.getModel().getPath());
            this.g2D.setStroke(stroke);
        }
        if (this.debugRegions) {
            int[][] nArray = BarrierList.currentCollisionArray;
            this.g2D.setColor(new Color(Color.pink.getRed(), Color.pink.getGreen(), Color.pink.getBlue(), 128));
            for (int i = 0; i < nArray.length; ++i) {
                for (n = 0; n < nArray[i].length; ++n) {
                    if (nArray[i][n] != 1) continue;
                    this.g2D.fillRect(i, n, 1, 1);
                }
            }
        }
    }

    class FieldMouseListener
    extends MouseAdapter {
        FieldMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (PlayingField.this.plusBag.contains(mouseEvent.getPoint())) {
                PlayingField.this.newChargeIsGrabbed = true;
                PlayingField.this.grabbedCharge = new Charge(mouseEvent.getPoint(), 1);
                PlayingField.this.grabbedChargeForce = new Force(PlayingField.this.grabbedCharge, PlayingField.this.electricHockeySimulationPanel.getModel().getPuck());
            } else if (PlayingField.this.minusBag.contains(mouseEvent.getPoint())) {
                PlayingField.this.newChargeIsGrabbed = true;
                PlayingField.this.grabbedCharge = new Charge(mouseEvent.getPoint(), -1);
                PlayingField.this.grabbedChargeForce = new Force(PlayingField.this.grabbedCharge, PlayingField.this.electricHockeySimulationPanel.getModel().getPuck());
            } else {
                for (int i = 0; i < PlayingField.this.electricHockeySimulationPanel.getModel().getChargeListSize(); ++i) {
                    Charge charge = PlayingField.this.electricHockeySimulationPanel.getModel().getChargeAt(i);
                    if (!charge.contains(mouseEvent.getPoint())) continue;
                    PlayingField.this.oldChargeIsGrabbed = true;
                    PlayingField.this.grabbedChargeIndex = i;
                    PlayingField.this.grabbedCharge = charge;
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PlayingField.this.newChargeIsGrabbed) {
                PlayingField.this.newChargeIsGrabbed = false;
                if (!PlayingField.this.chargeBag.contains(mouseEvent.getPoint())) {
                    PlayingField.this.electricHockeySimulationPanel.getModel().addCharge(PlayingField.this.grabbedCharge);
                    PlayingField.this.electricHockeySimulationPanel.getControlPanel().setNbrChargesLbl(PlayingField.this.electricHockeySimulationPanel.getModel().getChargeListSize());
                }
            }
            if (PlayingField.this.oldChargeIsGrabbed) {
                PlayingField.this.oldChargeIsGrabbed = false;
                if (PlayingField.this.chargeBag.contains(mouseEvent.getPoint())) {
                    PlayingField.this.electricHockeySimulationPanel.getModel().removeChargeAt(PlayingField.this.grabbedChargeIndex);
                    PlayingField.this.electricHockeySimulationPanel.getControlPanel().setNbrChargesLbl(PlayingField.this.electricHockeySimulationPanel.getModel().getChargeListSize());
                }
            }
            PlayingField.this.electricHockeySimulationPanel.getFieldGrid().updateGridForceArray();
            PlayingField.this.updateBufferedImage();
            PlayingField.this.repaint();
        }
    }

    class FieldMouseMotionListener
    extends MouseMotionAdapter {
        FieldMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Object object;
            if (PlayingField.this.newChargeIsGrabbed || PlayingField.this.oldChargeIsGrabbed) {
                PlayingField.this.grabbedCharge.setPosition(mouseEvent.getPoint());
                PlayingField.this.grabbedChargeForce = new Force(PlayingField.this.grabbedCharge, PlayingField.this.electricHockeySimulationPanel.getModel().getPuck());
            }
            if (PlayingField.this.oldChargeIsGrabbed) {
                PlayingField.this.electricHockeySimulationPanel.getModel().getChargeList().setElementAt(PlayingField.this.grabbedCharge, PlayingField.this.grabbedChargeIndex);
                object = PlayingField.this.electricHockeySimulationPanel.getModel().getPuck();
                Force force = new Force(PlayingField.this.grabbedCharge, (Charge)object);
                PlayingField.this.electricHockeySimulationPanel.getModel().getForceList().setElementAt(force, PlayingField.this.grabbedChargeIndex);
                PlayingField.this.electricHockeySimulationPanel.getFieldGrid().updateGridForceArray();
            }
            object = (Graphics2D)PlayingField.this.fieldLinesImage.getGraphics();
            PlayingField.this.electricHockeySimulationPanel.getFieldGrid().paint((Graphics2D)object);
            PlayingField.this.repaint();
        }
    }
}

