/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.electrichockey;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.electrichockey.Charge;
import edu.colorado.phet.electrichockey.ElectricHockeyArrow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;

public class Force {
    private Charge charge;
    private Color gridColor;
    private Point chargePt;
    private Point2D displacement;
    private double r;
    private double cutoff;
    private double rSq;
    private double xComp;
    private double yComp;
    private int xCompInt;
    private int yCompInt;
    private double x0;
    private double y0;
    private int x0Int;
    private int y0Int;
    private double forceFactor = 1000000.0;
    private ElectricHockeyArrow forceArrow;

    public Force(Charge charge, Charge charge2) {
        this.charge = charge;
        this.chargePt = charge.getPosition();
        this.x0 = charge2.getPosition2D().getX();
        this.y0 = charge2.getPosition2D().getY();
        this.displacement = new Point2D.Double(this.x0 - (double)this.chargePt.x, this.y0 - (double)this.chargePt.y);
        this.r = charge2.getPosition2D().distance(this.chargePt);
        this.cutoff = 25.0;
        if (this.r < this.cutoff) {
            this.r = this.cutoff;
        }
        this.rSq = this.r * this.r;
        this.xComp = this.forceFactor * (double)charge.getSign() * (double)charge2.getSign() * this.displacement.getX() / (this.r * this.rSq);
        this.yComp = this.forceFactor * (double)charge.getSign() * (double)charge2.getSign() * this.displacement.getY() / (this.r * this.rSq);
        this.forceArrow = new ElectricHockeyArrow();
        this.forceArrow.setPosition((int)this.x0, (int)this.y0, (int)this.x0 + (int)this.xComp, (int)this.y0 + (int)this.yComp);
    }

    public Force(double d, double d2) {
        this.xComp = d;
        this.yComp = d2;
    }

    public Force(double d, double d2, Charge charge, Color color) {
        this.xComp = d;
        this.yComp = d2;
        this.xCompInt = (int)d;
        this.yCompInt = (int)d2;
        this.charge = charge;
        this.gridColor = color;
        this.x0 = charge.getPosition2D().getX();
        this.y0 = charge.getPosition2D().getY();
        this.x0Int = (int)this.x0;
        this.y0Int = (int)this.y0;
    }

    public double getXComp() {
        return this.xComp;
    }

    public double getYComp() {
        return this.yComp;
    }

    public void paint(Graphics graphics) {
        if (this.charge.getSign() == 1) {
            graphics.setColor(Color.pink);
        } else if (this.charge.getSign() == -1) {
            graphics.setColor(Color.cyan);
        }
        this.forceArrow.paint(graphics);
    }

    public void paintGridArrow(Graphics2D graphics2D) {
        Point point = new Point(this.x0Int, this.y0Int);
        Point point2 = new Point(this.x0Int + this.xCompInt, this.y0Int + this.yCompInt);
        Arrow arrow = new Arrow(point, point2, 6.0, 6.0, 2.0, 3.0, true);
        graphics2D.setColor(this.gridColor);
        graphics2D.draw(arrow.getShape());
    }
}

