/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.electrichockey;

import edu.colorado.phet.electrichockey.Charge;
import edu.colorado.phet.electrichockey.ElectricHockeySimulationPanel;
import edu.colorado.phet.electrichockey.Force;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Vector;

public class FieldGrid {
    private ElectricHockeySimulationPanel electricHockeySimulationPanel;
    private int width;
    private int height;
    private int gridNbrWidth;
    private int gridSpacing;
    private int gridNbrHeight;
    private Charge[][] gridChargeArray;
    private Force[][] gridForceArray;
    private double gridForceFactor;
    private boolean antialias = false;

    public FieldGrid(int n, int n2, ElectricHockeySimulationPanel electricHockeySimulationPanel) {
        this.width = n;
        this.height = n2;
        this.electricHockeySimulationPanel = electricHockeySimulationPanel;
        this.gridForceFactor = 25.0;
        this.gridNbrWidth = 25;
        this.gridSpacing = n / this.gridNbrWidth;
        this.gridNbrHeight = n2 / this.gridSpacing;
        this.gridChargeArray = new Charge[this.gridNbrWidth][this.gridNbrHeight];
        this.gridForceArray = new Force[this.gridNbrWidth][this.gridNbrHeight];
        this.initializeGridChargesAndForces();
    }

    public void initializeGridChargesAndForces() {
        for (int i = 0; i < this.gridNbrWidth; ++i) {
            for (int j = 0; j < this.gridNbrHeight; ++j) {
                Force force;
                Point point = new Point(i * this.gridSpacing + this.gridSpacing / 2, j * this.gridSpacing + this.gridSpacing / 2);
                this.gridChargeArray[i][j] = new Charge(point, 3);
                this.gridForceArray[i][j] = force = new Force(0.0, 0.0, this.gridChargeArray[i][j], new Color(250, 250, 250));
            }
        }
    }

    public void updateGridForceArray() {
        Vector vector = this.electricHockeySimulationPanel.getModel().getChargeList();
        for (int i = 0; i < this.gridNbrWidth; ++i) {
            for (int j = 0; j < this.gridNbrHeight; ++j) {
                int n;
                double d = 0.0;
                double d2 = 0.0;
                for (n = 0; n < vector.size(); ++n) {
                    Charge charge = (Charge)vector.elementAt(n);
                    Force force = new Force(charge, this.gridChargeArray[i][j]);
                    d += force.getXComp();
                    d2 += force.getYComp();
                }
                n = 0;
                double d3 = 1.0;
                double d4 = (double)n + Math.pow(Math.pow(d, 2.0) + Math.pow(d2, 2.0), 0.5);
                int n2 = 100;
                double d5 = Math.pow(d4, d3);
                n2 = (int)(-255.0 * d5 / 300.0 + 255.0);
                if (n2 < 1) {
                    n2 = 1;
                } else if (n2 > 255) {
                    n2 = 255;
                }
                Color color = new Color(n2, n2, n2);
                this.gridForceArray[i][j] = new Force(this.gridForceFactor * d / d4, this.gridForceFactor * d2 / d4, this.gridChargeArray[i][j], color);
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setColor(Color.white);
        graphics2D.setBackground(Color.white);
        graphics2D.fillRect(0, 0, this.width, this.height);
        if (this.antialias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        for (int i = 0; i < this.gridNbrWidth; ++i) {
            for (int j = 0; j < this.gridNbrHeight; ++j) {
                this.gridForceArray[i][j].paintGridArrow(graphics2D);
            }
        }
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean bl) {
        this.antialias = bl;
        this.electricHockeySimulationPanel.getPlayingField().updateBufferedImage();
        this.electricHockeySimulationPanel.getPlayingField().repaint();
    }
}

