/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.electrichockey;

import edu.colorado.phet.common.phetcommon.audio.PhetAudioClip;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.electrichockey.ControlPanel;
import edu.colorado.phet.electrichockey.FieldGrid;
import edu.colorado.phet.electrichockey.Model;
import edu.colorado.phet.electrichockey.PlayingField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;

public class ElectricHockeySimulationPanel
extends JPanel
implements Runnable {
    private int width;
    private int height;
    private PlayingField playingField;
    private Model model;
    private FieldGrid fieldGrid;
    private ControlPanel controlPanel;
    private PhetAudioClip tada;
    private PhetAudioClip cork;
    private Image plusDisk;
    private Image minusDisk;
    private Image plusBag;
    private Image minusBag;
    private Image positivePuckImage;
    private Container pane;
    public Image negativePuckImage;

    public void init() {
        this.width = 700;
        this.height = 600;
        this.model = new Model(this.width, this.height, this);
        this.fieldGrid = new FieldGrid(this.width, this.height, this);
        this.controlPanel = new ControlPanel(this);
        this.playingField = new PlayingField(this.width, this.height, this);
        new Thread(this).start();
        this.plusDisk = this.getImage("plusDisk.gif");
        this.minusDisk = this.getImage("minusDisk.gif");
        this.plusBag = this.getImage("plusBag.gif");
        this.minusBag = this.getImage("minusBag.gif");
        this.positivePuckImage = this.getImage("puckPositive.gif");
        this.negativePuckImage = this.getImage("puckNegative.gif");
        this.pane = this;
        this.pane.setLayout(new BorderLayout());
        this.pane.add((Component)this.playingField, "Center");
        this.pane.add((Component)this.controlPanel, "South");
    }

    public Image getImage(String string) {
        return new PhetResources("electric-hockey").getImage(string);
    }

    public void paintComponent(Graphics graphics) {
    }

    public PlayingField getPlayingField() {
        return this.playingField;
    }

    public FieldGrid getFieldGrid() {
        return this.fieldGrid;
    }

    public Model getModel() {
        return this.model;
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public void run() {
        this.tada = new PhetAudioClip("electric-hockey/audio/tada.WAV");
        this.cork = new PhetAudioClip("electric-hockey/audio/cork.wav");
    }

    public boolean isAntialias() {
        return this.fieldGrid.isAntialias();
    }

    public Image getPlusBag() {
        return this.plusBag;
    }

    public Image getMinusBag() {
        return this.minusBag;
    }

    public Image getMinusDisk() {
        return this.minusDisk;
    }

    public Image getPlusDisk() {
        return this.plusDisk;
    }

    public Image getPositivePuckImage() {
        return this.positivePuckImage;
    }

    public Image getNegativePuckImage() {
        return this.negativePuckImage;
    }

    public PhetAudioClip getCork() {
        return this.cork;
    }

    public PhetAudioClip getTada() {
        return this.tada;
    }
}

