/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.electrichockey;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.util.LocaleUtils;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;
import edu.colorado.phet.electrichockey.ElectricHockeySimulationPanel;

public class ElectricHockeyApplication
extends PhetApplication {
    private ElectricHockeyModule module;

    public ElectricHockeyApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.module = new ElectricHockeyModule(phetApplicationConfig);
        this.addModule(this.module);
    }

    public static void main(String[] stringArray) {
        new PhetApplicationLauncher().launchSim(new ElectricHockeyApplicationConfig(stringArray), new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new ElectricHockeyApplication(phetApplicationConfig);
            }
        });
    }

    public static class ElectricHockeyApplicationConfig
    extends PhetApplicationConfig {
        public ElectricHockeyApplicationConfig(String[] stringArray) {
            super(stringArray, "electric-hockey");
            this.setFrameSetup(new FrameSetup.CenteredWithSize(800, 750));
            super.setLookAndFeel(new PhetLookAndFeel());
        }

        public String getName() {
            if (this.getResourceLoader().getLocale().equals(LocaleUtils.stringToLocale("en"))) {
                return super.getName() + " - derived from work by Ruth Chabay";
            }
            return super.getName();
        }
    }

    private class ElectricHockeyModule
    extends Module {
        public ElectricHockeyModule(PhetApplicationConfig phetApplicationConfig) {
            super(phetApplicationConfig.getName(), new ConstantDtClock(30, 1.0));
            ElectricHockeySimulationPanel electricHockeySimulationPanel = new ElectricHockeySimulationPanel();
            electricHockeySimulationPanel.init();
            this.setSimulationPanel(electricHockeySimulationPanel);
            this.setClockControlPanel(null);
            this.setLogoPanelVisible(false);
        }
    }
}

