/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class SwingUtils {
    public static void centerWindowOnScreen(Window window) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        window.setLocation((int)(dimension.getWidth() / 2.0 - (double)(window.getWidth() / 2)), (int)(dimension.getHeight() / 2.0 - (double)(window.getHeight() / 2)));
    }

    public static void centerDialogInParent(JDialog jDialog) {
        SwingUtils.centerInParent(jDialog);
    }

    public static void centerInParent(Component component) {
        Container container = component.getParent();
        if (container != null) {
            Rectangle rectangle = container.getBounds();
            Rectangle rectangle2 = new Rectangle((int)(rectangle.getMinX() + rectangle.getWidth() / 2.0 - (double)(component.getWidth() / 2)), (int)(rectangle.getMinY() + rectangle.getHeight() / 2.0 - (double)(component.getHeight() / 2)), component.getWidth(), component.getHeight());
            component.setLocation(rectangle2.x, rectangle2.y);
        }
    }

    public static void centerDialog(JDialog jDialog, Component component) {
        if (component == null) {
            SwingUtils.centerWindowOnScreen(jDialog);
        } else {
            SwingUtils.centerDialogInParent(jDialog);
        }
    }

    public static void fixButtonOpacity(JButton jButton) {
        if (!(UIManager.getLookAndFeel() instanceof MetalLookAndFeel)) {
            jButton.setOpaque(false);
        }
    }

    public static Dimension getMaxDimension(JButton jButton, String string, ImageIcon imageIcon, String string2, ImageIcon imageIcon2) {
        String string3 = jButton.getText();
        Icon icon = jButton.getIcon();
        jButton.setText(string);
        jButton.setIcon(imageIcon);
        Dimension dimension = jButton.getUI().getPreferredSize(jButton);
        jButton.setText(string2);
        jButton.setIcon(imageIcon2);
        Dimension dimension2 = jButton.getUI().getPreferredSize(jButton);
        jButton.setText(string3);
        jButton.setIcon(icon);
        int n = (int)Math.max(dimension.getWidth(), dimension2.getWidth());
        int n2 = (int)Math.max(dimension.getHeight(), dimension2.getHeight());
        return new Dimension(n, n2);
    }

    public static void setBackgroundDeep(Component component, Color color) {
        SwingUtils.setBackgroundDeep(component, color, null, true);
    }

    public static void setBackgroundDeep(Component component, Color color, Class[] classArray, boolean bl) {
        SwingUtils.setForegroundOrBackgroundDeep(false, component, color, classArray, bl);
    }

    private static void setForegroundOrBackgroundDeep(boolean bl, Component component, Color color, Class[] classArray, boolean bl2) {
        Container container;
        Component[] componentArray;
        boolean bl3 = false;
        if (classArray != null) {
            for (int i = 0; i < classArray.length && !bl3; ++i) {
                if (!classArray[i].isInstance(component)) continue;
                bl3 = true;
            }
        }
        if (!bl3) {
            if (bl) {
                component.setForeground(color);
            } else {
                component.setBackground(color);
            }
        }
        if ((!bl3 || bl2) && component instanceof Container && (componentArray = (container = (Container)component).getComponents()) != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                SwingUtils.setForegroundOrBackgroundDeep(bl, componentArray[i], color, classArray, bl2);
            }
        }
    }
}

