/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.graphics;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Arrow {
    private GeneralPath arrowPath = new GeneralPath();
    private Point2D tailLocation;
    private Point2D tipLocation;
    private double headHeight;
    private double headWidth;
    private double tailWidth;
    private double fractionalHeadHeight;
    private boolean scaleTailToo;
    private double headScale;
    private Vector2D direction;
    private Vector2D norm;
    boolean isHeadDynamic = false;

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Arrow) {
            Arrow arrow = (Arrow)object;
            bl = arrow.tailLocation.equals(this.tailLocation) && arrow.tipLocation.equals(this.tipLocation) && arrow.headHeight == this.headHeight && arrow.headWidth == this.headWidth && arrow.tailWidth == this.tailWidth && arrow.isHeadDynamic == this.isHeadDynamic;
        }
        return bl;
    }

    public Arrow(Point2D point2D, Point2D point2D2, double d, double d2, double d3, double d4, boolean bl) {
        this.fractionalHeadHeight = d4;
        this.scaleTailToo = bl;
        this.isHeadDynamic = true;
        this.init(point2D, point2D2, d, d2, d3);
        this.computeArrow();
    }

    void init(Point2D point2D, Point2D point2D2, double d, double d2, double d3) {
        this.tailLocation = point2D;
        this.tipLocation = point2D2;
        this.headHeight = d;
        this.headWidth = d2;
        this.tailWidth = d3;
    }

    private void computeArrow() {
        this.arrowPath.reset();
        if (this.tailLocation.distance(this.tipLocation) != 0.0) {
            Vector2D vector2D = new Vector2D(this.tailLocation);
            Vector2D vector2D2 = new Vector2D(this.tipLocation);
            Vector2D vector2D3 = vector2D2.minus(vector2D);
            this.direction = vector2D3.normalized();
            double d = this.tipLocation.distance(this.tailLocation);
            double d2 = this.headHeight;
            double d3 = this.headWidth;
            double d4 = this.tailWidth;
            if (this.isHeadDynamic) {
                if (d < this.headHeight / this.fractionalHeadHeight) {
                    d2 = d * this.fractionalHeadHeight;
                    if (this.scaleTailToo) {
                        d4 = this.tailWidth * d2 / this.headHeight;
                        d3 = this.headWidth * d2 / this.headHeight;
                    }
                }
            } else if (d < this.headHeight) {
                throw new RuntimeException("headHeight is bigger than arrow length: length=" + d + " headHeight=" + this.headHeight);
            }
            this.headScale = d2 / this.headHeight;
            this.norm = this.direction.getPerpendicularVector();
            Vector2D vector2D4 = this.getPoint(-1.0 * d2, -d3 / 2.0);
            Vector2D vector2D5 = this.getPoint(-1.0 * d2, d3 / 2.0);
            Vector2D vector2D6 = this.getPoint(-1.0 * d2, -d4 / 2.0);
            Vector2D vector2D7 = this.getPoint(-1.0 * d2, d4 / 2.0);
            Vector2D vector2D8 = this.getPoint(-1.0 * d, -d4 / 2.0);
            Vector2D vector2D9 = this.getPoint(-1.0 * d, d4 / 2.0);
            this.arrowPath.moveTo((float)vector2D2.getX(), (float)vector2D2.getY());
            this.lineTo(this.arrowPath, vector2D4);
            this.lineTo(this.arrowPath, vector2D6);
            this.lineTo(this.arrowPath, vector2D8);
            this.lineTo(this.arrowPath, vector2D9);
            this.lineTo(this.arrowPath, vector2D7);
            this.lineTo(this.arrowPath, vector2D5);
            this.arrowPath.closePath();
        }
    }

    private void lineTo(GeneralPath generalPath, Vector2D vector2D) {
        generalPath.lineTo((float)vector2D.getX(), (float)vector2D.getY());
    }

    private Vector2D getPoint(double d, double d2) {
        double d3 = this.direction.getX() * d + this.norm.getX() * d2 + this.tipLocation.getX();
        double d4 = this.direction.getY() * d + this.norm.getY() * d2 + this.tipLocation.getY();
        return new Vector2D(d3, d4);
    }

    public GeneralPath getShape() {
        return this.arrowPath;
    }
}

