/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import java.util.Locale;
import java.util.StringTokenizer;

public class LocaleUtils {
    private LocaleUtils() {
    }

    public static String getTranslationFileSuffix(Locale locale) {
        assert (locale != null);
        if (locale.equals(new Locale("en"))) {
            return "";
        }
        return "_" + LocaleUtils.localeToString(locale);
    }

    public static String localeToString(Locale locale) {
        assert (locale != null);
        return locale.toString();
    }

    public static Locale stringToLocale(String string) {
        assert (string != null);
        Locale locale = null;
        if (string.matches("test")) {
            locale = new Locale(string);
        } else if (string.matches("[a-z][a-z]")) {
            locale = new Locale(string);
        } else if (string.matches("[a-z][a-z](_[A-Z][A-Z])?")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            locale = new Locale(string2, string3);
        } else {
            throw new IllegalArgumentException("malformed locale string: " + string);
        }
        return locale;
    }
}

