/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.laws;

import edu.colorado.phet.efield.core.ParticleList;
import edu.colorado.phet.efield.laws.MyForceLaw;
import edu.colorado.phet.efield.phys2d_efield.DoublePoint;
import edu.colorado.phet.efield.phys2d_efield.Law;
import edu.colorado.phet.efield.phys2d_efield.Particle;
import edu.colorado.phet.efield.phys2d_efield.System2D;

public class ForceLawAdapter
extends ParticleList
implements Law {
    MyForceLaw law;

    public ForceLawAdapter(Particle[] particleArray, MyForceLaw myForceLaw) {
        this.addAll(particleArray);
        this.law = myForceLaw;
        if (myForceLaw == null) {
            throw new RuntimeException("Law is null.");
        }
    }

    public String toString() {
        return this.getClass().getName() + ", law=" + this.law + ", numCharges=" + this.numParticles();
    }

    public void iterate(double d, System2D system2D) {
        for (int i = 0; i < this.numParticles(); ++i) {
            DoublePoint doublePoint = new DoublePoint();
            for (int j = 0; j < this.numParticles(); ++j) {
                if (i == j) continue;
                doublePoint = doublePoint.add(this.law.getForce(this.particleAt(j), this.particleAt(i)));
            }
            double d2 = this.particleAt(i).getMass();
            DoublePoint doublePoint2 = doublePoint.multiply(1.0 / d2);
            DoublePoint doublePoint3 = this.particleAt(i).getAcceleration();
            DoublePoint doublePoint4 = doublePoint3.add(doublePoint2);
            this.particleAt(i).setAcceleration(doublePoint4);
        }
    }
}

