/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.laws;

import edu.colorado.phet.efield.laws.MyForceLaw;
import edu.colorado.phet.efield.phys2d_efield.DoublePoint;
import edu.colorado.phet.efield.phys2d_efield.Particle;

public class CoulombsLaw
implements MyForceLaw {
    double range;
    double k;
    double minDist;

    public CoulombsLaw(double d) {
        this(Double.MAX_VALUE, d);
    }

    public CoulombsLaw(double d, double d2) {
        this(d, d2, 0.0);
    }

    public CoulombsLaw(double d, double d2, double d3) {
        this.range = d;
        this.k = d2;
        this.minDist = d3;
    }

    public DoublePoint getForce(Particle particle, Particle particle2) {
        DoublePoint doublePoint;
        DoublePoint doublePoint2 = particle.getPosition();
        DoublePoint doublePoint3 = doublePoint2.subtract(doublePoint = particle2.getPosition());
        double d = doublePoint3.getLength();
        if (d < this.minDist) {
            d = this.minDist;
        }
        if (d > this.range) {
            return new DoublePoint(0.0, 0.0);
        }
        double d2 = Math.pow(d, 3.0);
        double d3 = -this.k * particle.getCharge() * particle2.getCharge() / d2;
        if (Double.isInfinite(d3) || Double.isNaN(d3) || Double.isNaN(doublePoint3.getX()) || Double.isNaN(doublePoint3.getY())) {
            return new DoublePoint();
        }
        DoublePoint doublePoint4 = doublePoint3.multiply(d3);
        return doublePoint4;
    }
}

