/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.gui.mouse;

import edu.colorado.phet.efield.gui.ParticlePanel;
import edu.colorado.phet.efield.gui.mouse.ParticleGrabber;
import edu.colorado.phet.efield.gui.mouse.TimedPoint;
import edu.colorado.phet.efield.phys2d_efield.DoublePoint;
import edu.colorado.phet.efield.phys2d_efield.System2D;
import edu.colorado.phet.efield.phys2d_efield.SystemRunner;
import edu.colorado.phet.efield.utils.TruncatedSeries;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class ParticleThrower
extends ParticleGrabber {
    TruncatedSeries ts;
    int maxSeriesSize;
    double scale;

    public ParticleThrower(ParticlePanel particlePanel, System2D system2D, SystemRunner systemRunner, int n, double d) {
        super(particlePanel, system2D, systemRunner);
        this.scale = d;
        this.ts = new TruncatedSeries(n);
        this.maxSeriesSize = n;
    }

    private DoublePoint getAverageVelocity(Vector vector) {
        if (vector.size() == 0 || vector.size() == 1) {
            return new DoublePoint(0.0, 0.0);
        }
        DoublePoint[] doublePointArray = vector.toArray(new DoublePoint[vector.size()]);
        Vector<DoublePoint> vector2 = new Vector<DoublePoint>();
        for (int i = 0; i < doublePointArray.length - 1; ++i) {
            vector2.add(doublePointArray[i + 1].subtract(doublePointArray[i]));
        }
        DoublePoint[] doublePointArray2 = vector2.toArray(new DoublePoint[vector2.size()]);
        DoublePoint doublePoint = DoublePoint.average(doublePointArray2);
        return doublePoint;
    }

    private DoublePoint timedPointsToVelocity(Vector vector) {
        long l = 100L;
        Vector<DoublePoint> vector2 = new Vector<DoublePoint>();
        TimedPoint[] timedPointArray = vector.toArray(new TimedPoint[vector.size()]);
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < timedPointArray.length; ++i) {
            if (timedPointArray[i].getAge(l2) >= l) continue;
            vector2.add(timedPointArray[i].getDoublePoint());
        }
        return this.getAverageVelocity(vector2);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.selectedParticle == null) {
            return;
        }
        Vector vector = this.ts.get();
        DoublePoint doublePoint = this.timedPointsToVelocity(vector);
        if (Double.isNaN(doublePoint.getX())) {
            doublePoint = new DoublePoint(0.0, doublePoint.getY());
        }
        if (Double.isNaN(doublePoint.getX())) {
            doublePoint = new DoublePoint(doublePoint.getX(), 0.0);
        }
        doublePoint = doublePoint.multiply(this.scale);
        this.selectedParticle.setVelocity(doublePoint);
        super.mouseReleased(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.ts = new TruncatedSeries(this.maxSeriesSize);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (this.selectedParticle == null) {
            return;
        }
        DoublePoint doublePoint = new DoublePoint(mouseEvent.getX(), mouseEvent.getY());
        TimedPoint timedPoint = new TimedPoint(doublePoint, System.currentTimeMillis());
        this.ts.add(timedPoint);
        this.particlePanel.repaint();
    }
}

