/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.gui.mouse;

import edu.colorado.phet.efield.gui.ParticlePanel;
import edu.colorado.phet.efield.gui.media.EFieldResettable;
import edu.colorado.phet.efield.gui.mouse.ParticleSelector;
import edu.colorado.phet.efield.phys2d_efield.DoublePoint;
import edu.colorado.phet.efield.phys2d_efield.Particle;
import edu.colorado.phet.efield.phys2d_efield.System2D;
import edu.colorado.phet.efield.phys2d_efield.SystemRunner;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ParticleGrabber
implements EFieldResettable,
MouseListener,
MouseMotionListener {
    ParticlePanel particlePanel;
    Particle selectedParticle;
    System2D system2D;
    SystemRunner systemRunner;
    ParticleSelector particleSelector;

    public ParticleGrabber(ParticlePanel particlePanel, System2D system2D, SystemRunner systemRunner) {
        this.systemRunner = systemRunner;
        this.particlePanel = particlePanel;
        this.selectedParticle = null;
        this.system2D = system2D;
        this.particleSelector = new ParticleSelector(particlePanel);
    }

    public void fireResetAction(ParticlePanel particlePanel) {
        this.particlePanel = particlePanel;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.selectedParticle != null) {
            this.system2D.addParticle(this.selectedParticle);
        }
        this.selectedParticle = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Particle particle;
        Point point = mouseEvent.getPoint();
        this.selectedParticle = particle = this.particleSelector.selectAt(point);
        if (particle != null) {
            this.system2D.remove(this.selectedParticle);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selectedParticle == null) {
            return;
        }
        this.selectedParticle.setPosition(new DoublePoint(mouseEvent.getX(), mouseEvent.getY()));
        this.particlePanel.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

