/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.gui.addRemove;

import edu.colorado.phet.efield.EFieldResources;
import edu.colorado.phet.efield.core.ParticleContainer;
import edu.colorado.phet.efield.core.ParticleFactory;
import edu.colorado.phet.efield.gui.ParticlePainter;
import edu.colorado.phet.efield.gui.ParticlePanel;
import edu.colorado.phet.efield.gui.media.EFieldResettable;
import edu.colorado.phet.efield.phys2d_efield.Particle;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class AddRemove
implements EFieldResettable {
    Vector containers;
    Vector electrons;
    ParticleFactory pf;
    Component paintMe;
    ParticlePainter painter;

    public AddRemove(Vector vector, ParticleFactory particleFactory, Component component, ParticlePainter particlePainter) {
        this.paintMe = component;
        this.electrons = vector;
        this.pf = particleFactory;
        this.containers = new Vector();
        this.painter = particlePainter;
    }

    public void add(ParticleContainer particleContainer) {
        this.containers.add(particleContainer);
    }

    public void fireResetAction(ParticlePanel particlePanel) {
        while (this.electrons.size() > 0) {
            this.remove();
        }
    }

    public JPanel getJPanel() {
        JButton jButton = new JButton(EFieldResources.getString("AddRemove.AddButton"));
        jButton.addActionListener(new Adder());
        JButton jButton2 = new JButton(EFieldResources.getString("AddRemove.RemoveButton"));
        jButton2.addActionListener(new Remover());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    public ParticleContainer containerAt(int n) {
        return (ParticleContainer)this.containers.get(n);
    }

    public void addElectron() {
        Particle particle = this.pf.newParticle();
        for (int i = 0; i < this.containers.size(); ++i) {
            ParticleContainer particleContainer = this.containerAt(i);
            particleContainer.add(particle);
        }
        this.electrons.add(particle);
        this.paintMe.repaint();
    }

    public void remove() {
        if (this.electrons.size() > 0) {
            Particle particle = (Particle)this.electrons.lastElement();
            this.remove(particle);
        }
    }

    public void remove(Particle particle) {
        for (int i = 0; i < this.containers.size(); ++i) {
            this.containerAt(i).remove(particle);
        }
        this.electrons.remove(particle);
        this.paintMe.repaint();
    }

    public class Adder
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AddRemove.this.addElectron();
        }
    }

    public class Remover
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AddRemove.this.remove();
        }
    }
}

