/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.gui;

import edu.colorado.phet.efield.gui.Painter;
import edu.colorado.phet.efield.gui.ParticlePainter;
import edu.colorado.phet.efield.phys2d_efield.Particle;
import edu.colorado.phet.efield.phys2d_efield.System2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Vector;
import javax.swing.JPanel;

public class ParticlePanel
extends JPanel {
    Vector particles = new Vector();
    Vector painters = new Vector();
    Vector graphicsPainters = new Vector();
    Vector postPainters = new Vector();

    public void add(Painter painter) {
        this.graphicsPainters.add(painter);
    }

    public int numParticles() {
        return this.particles.size();
    }

    public void removeParticle(int n) {
        this.particles.remove(n);
        this.painters.remove(n);
    }

    public void remove(Particle particle) {
        int n = this.particles.indexOf(particle);
        if (n == -1) {
            return;
        }
        this.removeParticle(n);
    }

    public Particle particleAt(int n) {
        return (Particle)this.particles.get(n);
    }

    public ParticlePainter painterAt(int n) {
        return (ParticlePainter)this.painters.get(n);
    }

    public void reset() {
        this.particles = new Vector();
        this.painters = new Vector();
    }

    public void addAll(System2D system2D, ParticlePainter particlePainter) {
        for (int i = 0; i < system2D.numParticles(); ++i) {
            this.add(system2D.particleAt(i), particlePainter);
        }
    }

    public void add(Particle particle, ParticlePainter particlePainter) {
        this.particles.add(particle);
        this.painters.add(particlePainter);
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(graphics);
        Graphics2D graphics2D2 = (Graphics2D)graphics;
        for (n = 0; n < this.graphicsPainters.size(); ++n) {
            object = (Painter)this.graphicsPainters.get(n);
            object.paint(graphics2D2);
        }
        for (n = 0; n < this.painters.size(); ++n) {
            object = (Particle)this.particles.get(n);
            ParticlePainter particlePainter = (ParticlePainter)this.painters.get(n);
            particlePainter.paint((Particle)object, graphics2D2);
        }
        for (n = 0; n < this.postPainters.size(); ++n) {
            object = (Painter)this.postPainters.get(n);
            object.paint(graphics2D2);
        }
    }
}

