/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.electricField;

import edu.colorado.phet.efield.EFieldResources;
import edu.colorado.phet.efield.electricField.ChargeFieldSource;
import edu.colorado.phet.efield.gui.popupMenu.MenuConstructor;
import edu.colorado.phet.efield.phys2d_efield.Particle;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class FieldMenuConstructor
implements MenuConstructor {
    ChargeFieldSource cfs;
    Component paintMe;

    public FieldMenuConstructor(ChargeFieldSource chargeFieldSource, Component component) {
        this.cfs = chargeFieldSource;
        this.paintMe = component;
    }

    public JMenu getMenu(Particle particle) {
        JMenu jMenu = new JMenu(EFieldResources.getString("FieldMenuConstructor.ParticleMenuTitle"));
        ShowEField showEField = new ShowEField(this.cfs, particle, this.paintMe);
        showEField.setSelected(!this.cfs.isIgnoring(particle));
        jMenu.add(showEField);
        return jMenu;
    }

    public static class ShowEField
    extends JCheckBoxMenuItem
    implements ActionListener {
        ChargeFieldSource cfs;
        Particle p;
        Component paintMe;

        public ShowEField(ChargeFieldSource chargeFieldSource, Particle particle, Component component) {
            super(EFieldResources.getString("FieldMenuConstructor.ShowContributionCheckBox"), true);
            this.cfs = chargeFieldSource;
            this.p = particle;
            this.addActionListener(this);
            this.paintMe = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isSelected()) {
                this.cfs.removeFromIgnore(this.p);
            } else {
                this.cfs.ignore(this.p);
            }
            this.paintMe.repaint();
        }
    }
}

