/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.electricField;

import edu.colorado.phet.efield.electricField.ElectricFieldSource;
import edu.colorado.phet.efield.gui.vectorChooser.VectorListener;
import edu.colorado.phet.efield.phys2d_efield.DoublePoint;
import edu.colorado.phet.efield.phys2d_efield.Law;
import edu.colorado.phet.efield.phys2d_efield.Particle;
import edu.colorado.phet.efield.phys2d_efield.System2D;

public class ElectricForceLaw
implements ElectricFieldSource,
VectorListener,
Law {
    DoublePoint field;

    public ElectricForceLaw(DoublePoint doublePoint) {
        this.field = doublePoint;
    }

    public void vectorChanged(DoublePoint doublePoint) {
        this.field = doublePoint;
    }

    public DoublePoint getField(double d, double d2) {
        return this.field;
    }

    public void iterate(double d, System2D system2D) {
        for (int i = 0; i < system2D.numParticles(); ++i) {
            Particle particle = system2D.particleAt(i);
            DoublePoint doublePoint = this.field.multiply(particle.getCharge());
            double d2 = particle.getMass();
            DoublePoint doublePoint2 = doublePoint.multiply(1.0 / d2);
            DoublePoint doublePoint3 = particle.getAcceleration();
            DoublePoint doublePoint4 = doublePoint3.add(doublePoint2);
            particle.setAcceleration(doublePoint4);
        }
    }
}

