/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.efield.electricField;

import edu.colorado.phet.efield.core.ParticleContainer;
import edu.colorado.phet.efield.electricField.ElectricFieldSource;
import edu.colorado.phet.efield.phys2d_efield.DoublePoint;
import edu.colorado.phet.efield.phys2d_efield.Particle;
import java.util.Vector;

public class ChargeFieldSource
implements ElectricFieldSource {
    ParticleContainer pc;
    double k;
    double max;
    Vector ignore;

    public ChargeFieldSource(ParticleContainer particleContainer, double d, double d2) {
        this.pc = particleContainer;
        this.k = d;
        this.max = d2;
        this.ignore = new Vector();
    }

    public boolean isIgnoring(Particle particle) {
        return this.ignore.contains(particle);
    }

    public void removeFromIgnore(Particle particle) {
        while (this.ignore.contains(particle)) {
            this.ignore.remove(particle);
        }
    }

    public void ignore(Particle particle) {
        this.ignore.add(particle);
    }

    public DoublePoint getField(double d, double d2) {
        DoublePoint doublePoint = new DoublePoint();
        DoublePoint doublePoint2 = new DoublePoint(d, d2);
        for (int i = 0; i < this.pc.numParticles(); ++i) {
            Particle particle = this.pc.particleAt(i);
            if (this.ignore.contains(particle)) continue;
            DoublePoint doublePoint3 = this.getField(particle, doublePoint2);
            doublePoint = doublePoint.add(doublePoint3);
        }
        return doublePoint;
    }

    public DoublePoint getField(Particle particle, DoublePoint doublePoint) {
        double d = particle.getCharge();
        DoublePoint doublePoint2 = particle.getPosition();
        DoublePoint doublePoint3 = doublePoint.subtract(doublePoint2);
        double d2 = doublePoint3.getLength();
        if (d2 == 0.0) {
            return new DoublePoint();
        }
        double d3 = Math.pow(d2, -3.0) * this.k * d;
        double d4 = (doublePoint3 = doublePoint3.multiply(d3)).getLength();
        if (d4 > this.max) {
            double d5 = this.max / d4;
            doublePoint3 = doublePoint3.multiply(d5);
        }
        return doublePoint3;
    }
}

