/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.model;

import edu.colorado.phet.eatingandexercise.model.EatingAndExerciseUnits;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.colorado.phet.eatingandexercise.model.HumanUpdate;

public class MuscleAndFatMassLoss2
implements HumanUpdate {
    public static double FRACTION_FAT_LOST = 0.5;
    public static boolean allFatWhenGainingWeight = true;

    public void update(Human human, double d) {
        double d2;
        double d3 = human.getDeltaCaloriesGainedPerDay();
        double d4 = d3 * EatingAndExerciseUnits.secondsToDays(d);
        double d5 = human.getFatMass() / human.getMass();
        double d6 = d5 * human.getGender().getFatMassMultiplier();
        if (d5 > human.getGender().getFatMassLimiter()) {
            d6 = 1.0;
        }
        if (human.isAlmostStarving()) {
            d6 = 0.5;
        } else if (human.isStarving()) {
            d6 = 0.05;
        }
        if (d4 > 0.0 && allFatWhenGainingWeight) {
            d6 = 1.0;
        }
        double d7 = -d4;
        double d8 = (d6 / 9000.0 + (1.0 - d6) / 4000.0) * d7;
        double d9 = d8 * d6;
        double d10 = human.getMass() - d8;
        if (d10 <= 1.0E-6) {
            d10 = 1.0E-6;
        }
        if ((d2 = human.getFatMass() - d9) <= 1.0E-6) {
            d2 = 1.0E-6;
        }
        double d11 = d2 / d10 * 100.0;
        if (d10 == 1.0E-6) {
            d11 = d5;
        }
        this.updateMass(human, d10);
        human.setFatMassPercent(d11);
    }

    private void updateMass(Human human, double d) {
        human.setMass(d);
        human.getMassVariable().addValue(d, human.getAge());
    }
}

