/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import java.util.ArrayList;

public abstract class CaloricItem
implements Cloneable {
    private String name;
    private String image;
    private double cal;
    private ArrayList listeners = new ArrayList();

    public CaloricItem(String string, String string2, double d) {
        this.name = string;
        this.image = string2;
        this.cal = d;
    }

    public String getName() {
        return this.name;
    }

    public String getImage() {
        return this.image;
    }

    public double getCalories() {
        return this.cal;
    }

    public String toString() {
        return "name=" + this.name + ", image=" + this.image + ", cal=" + this.cal;
    }

    public abstract String getLabelText();

    public Object clone() {
        try {
            CaloricItem caloricItem = (CaloricItem)super.clone();
            caloricItem.name = this.name;
            caloricItem.image = this.image;
            caloricItem.cal = this.cal;
            return caloricItem;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    protected void setCalories(double d) {
        this.cal = d;
        this.notifyCaloriesChanged();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyCaloriesChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).caloriesChanged();
        }
    }

    public static interface Listener {
        public void caloriesChanged();
    }
}

