/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.AWTSplashWindow;
import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.KSUCreditsWindow;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.sponsorship.SponsorDialog;
import edu.colorado.phet.common.phetcommon.sponsorship.SponsorMenuItem;
import edu.colorado.phet.common.phetcommon.statistics.StatisticsManager;
import edu.colorado.phet.common.phetcommon.updates.AutomaticUpdatesManager;
import edu.colorado.phet.common.phetcommon.updates.ManualUpdatesManager;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JSpinner;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class PhetApplicationLauncher {
    private AWTSplashWindow splashWindow;
    private Frame splashWindowOwner;

    private void showSplashWindow(String string) {
        if (this.splashWindow == null) {
            this.splashWindowOwner = new Frame();
            this.splashWindow = new AWTSplashWindow(this.splashWindowOwner, string);
            this.splashWindow.setVisible(true);
        }
    }

    private void disposeSplashWindow() {
        if (this.splashWindow != null) {
            this.splashWindow.dispose();
            this.splashWindow = null;
            this.splashWindowOwner.dispose();
            this.splashWindowOwner = null;
        }
    }

    public void launchSim(String[] stringArray, String string, Class clazz) {
        this.launchSim(stringArray, string, new ReflectionApplicationConstructor(clazz));
    }

    public void launchSim(String[] stringArray, String string, ApplicationConstructor applicationConstructor) {
        this.launchSim(new PhetApplicationConfig(stringArray, string), applicationConstructor);
    }

    public void launchSim(PhetApplicationConfig phetApplicationConfig, Class clazz) {
        this.launchSim(phetApplicationConfig, new ReflectionApplicationConstructor(clazz));
    }

    public void launchSim(final PhetApplicationConfig phetApplicationConfig, final ApplicationConstructor applicationConstructor) {
        SimSharingManager.init(phetApplicationConfig);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    phetApplicationConfig.getLookAndFeel().initLookAndFeel();
                    new JSpinner();
                    if (applicationConstructor != null) {
                        PhetApplicationLauncher.this.showSplashWindow(phetApplicationConfig.getName());
                        final PhetApplication phetApplication = applicationConstructor.getApplication(phetApplicationConfig);
                        phetApplication.startApplication();
                        PhetApplicationLauncher.this.disposeSplashWindow();
                        final VoidFunction0 voidFunction0 = new VoidFunction0(){

                            public void apply() {
                                if (SponsorDialog.shouldShow(phetApplicationConfig)) {
                                    SponsorDialog.show(phetApplicationConfig, phetApplication.getPhetFrame(), true);
                                    phetApplication.getPhetFrame().getHelpMenu().add(new SponsorMenuItem(phetApplicationConfig, phetApplication.getPhetFrame()));
                                }
                            }
                        };
                        if (KSUCreditsWindow.shouldShow(phetApplicationConfig)) {
                            JWindow jWindow = KSUCreditsWindow.show(phetApplication.getPhetFrame());
                            jWindow.addWindowListener(new WindowAdapter(){

                                public void windowClosed(WindowEvent windowEvent) {
                                    voidFunction0.apply();
                                }
                            });
                        } else {
                            voidFunction0.apply();
                        }
                        if (phetApplication.getSimInfo().getVersion().getMajorAsInt() >= 1) {
                            StatisticsManager.initInstance(phetApplication).start();
                            AutomaticUpdatesManager.initInstance(phetApplication).start();
                            ManualUpdatesManager.initInstance(phetApplication);
                        }
                    } else {
                        new RuntimeException("No applicationconstructor specified").printStackTrace();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public static class ReflectionApplicationConstructor
    implements ApplicationConstructor {
        private Class phetApplicationClass;

        public ReflectionApplicationConstructor(Class clazz) {
            this.phetApplicationClass = clazz;
        }

        public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
            try {
                return (PhetApplication)this.phetApplicationClass.getConstructor(phetApplicationConfig.getClass()).newInstance(phetApplicationConfig);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

