/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.model;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.CollisionExpert;
import edu.colorado.phet.common.collision.SphereBoxExpert;
import edu.colorado.phet.common.collision.SphereSphereExpert;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.common.quantum.model.PhotonAtomCollisonExpert;
import edu.colorado.phet.common.quantum.model.QuantumModel;
import edu.colorado.phet.common.quantum.model.Tube;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.lasers.model.atom.LaserElementProperties;
import edu.colorado.phet.lasers.model.atom.ThreeLevelElementProperties;
import edu.colorado.phet.lasers.model.atom.TwoLevelElementProperties;
import edu.colorado.phet.lasers.model.collision.PhotonMirrorCollisonExpert;
import edu.colorado.phet.lasers.model.mirror.Mirror;
import edu.colorado.phet.lasers.view.EnergyMatchDetector;
import edu.colorado.phet.lasers.view.MatchState;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class LaserModel
extends QuantumModel {
    public static Point2D ORIGIN = new Point2D.Double(100.0, 300.0);
    private static int width = 800;
    private static int height = 800;
    private static int minX = (int)LasersConfig.ORIGIN.getX() - 50;
    private static int minY = (int)LasersConfig.ORIGIN.getY() - height / 2;
    private Beam stimulatingBeam;
    private Beam pumpingBeam;
    private Tube tube;
    private List bodies = new LinkedList();
    private Rectangle2D boundingRectangle = new Rectangle2D.Double(minX, minY, width, height);
    private ArrayList photons = new ArrayList();
    private ArrayList atoms = new ArrayList();
    private ArrayList mirrors = new ArrayList();
    private CollisionMechanism collisionMechanism;
    private HashSet lasingPhotons = new HashSet();
    private double angleWindow = LasersConfig.PHOTON_CHEAT_ANGLE;
    private int numPhotons;
    private int numGroundStateAtoms;
    private int numMiddleStateAtoms;
    private int numHighStateAtoms;
    private LaserElementProperties twoLevelProperties = new TwoLevelElementProperties();
    private LaserElementProperties threeLevelProperties = new ThreeLevelElementProperties();
    private SimpleObservable observable = new SimpleObservable();
    private boolean modelPaused = false;
    private EventChannel laserEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.laserEventChannel.getListenerProxy();

    public void setModelPaused(boolean bl) {
        this.modelPaused = bl;
    }

    public LaserModel(double d) {
        super(d);
        this.setCurrentElementProperties(this.twoLevelProperties);
        this.collisionMechanism = new CollisionMechanism();
        this.collisionMechanism.addCollisionExpert(new SphereSphereExpert());
        this.collisionMechanism.addCollisionExpert(new PhotonAtomCollisonExpert());
        this.collisionMechanism.addCollisionExpert(new SphereBoxExpert());
        this.collisionMechanism.addCollisionExpert(new PhotonMirrorCollisonExpert());
        this.addModelElement(new CollisionAgent());
    }

    public void addModelElement(ModelElement modelElement) {
        super.addModelElement(modelElement);
        if (modelElement instanceof Collidable) {
            this.bodies.add(modelElement);
        }
        if (modelElement instanceof Photon) {
            this.addPhoton(modelElement);
        }
        if (modelElement instanceof Atom) {
            this.addAtom(modelElement);
        }
        if (modelElement instanceof Mirror) {
            this.mirrors.add(modelElement);
        }
        if (modelElement instanceof Tube) {
            this.tube = (Tube)modelElement;
        }
    }

    private void addAtom(ModelElement modelElement) {
        this.atoms.add(modelElement);
        Atom atom = (Atom)modelElement;
        atom.addChangeListener(new AtomChangeListener());
    }

    private void addPhoton(ModelElement modelElement) {
        this.photons.add(modelElement);
        Photon photon = (Photon)modelElement;
        ((Photon)modelElement).addLeftSystemListener(this);
        if (this.isLasingPhoton(photon)) {
            this.lasingPhotons.add(photon);
            this.changeListenerProxy.lasingPopulationChanged(new ChangeEvent(this));
        }
    }

    private boolean isLasingPhoton(Photon photon) {
        double d = this.getMiddleEnergyState().getEnergyLevel() - this.getGroundState().getEnergyLevel();
        return Math.abs(photon.getVelocity().getAngle() % Math.PI) < this.angleWindow && Math.abs(photon.getEnergy() - d) <= 0.05;
    }

    public void removeModelElement(ModelElement modelElement) {
        super.removeModelElement(modelElement);
        if (modelElement instanceof Collidable) {
            this.bodies.remove(modelElement);
        }
        if (modelElement instanceof Atom) {
            this.atoms.remove(modelElement);
        }
        if (modelElement instanceof Photon) {
            this.photons.remove(modelElement);
        }
        if (modelElement instanceof Mirror) {
            this.mirrors.remove(modelElement);
        }
    }

    public void reset() {
        this.getPumpingBeam().setPhotonsPerSecond(0.0);
        this.getSeedBeam().setPhotonsPerSecond(0.0);
        for (Object e : this.bodies) {
            if (!(e instanceof Atom)) continue;
            Atom atom = (Atom)e;
            atom.setCurrState(this.getGroundState());
        }
        while (!this.photons.isEmpty()) {
            Photon photon = (Photon)this.photons.get(0);
            photon.removeFromSystem();
        }
        this.numPhotons = 0;
    }

    public void update(ClockEvent clockEvent) {
        if (!this.modelPaused) {
            super.update(clockEvent);
            this.numPhotons = 0;
            for (int i = 0; i < this.bodies.size(); ++i) {
                Object e = this.bodies.get(i);
                if (!(e instanceof Photon)) continue;
                ++this.numPhotons;
                Photon photon = (Photon)e;
                Point2D point2D = photon.getPosition();
                if (this.boundingRectangle.contains(point2D.getX(), point2D.getY())) continue;
                photon.removeFromSystem();
            }
            this.observable.notifyObservers();
        }
    }

    public void addObserver(SimpleObserver simpleObserver) {
        this.observable.addObserver(simpleObserver);
    }

    public void setNumEnergyLevels(int n) {
        switch (n) {
            case 2: {
                this.setCurrentElementProperties(this.twoLevelProperties);
                this.getPumpingBeam().setEnabled(false);
                break;
            }
            case 3: {
                this.setCurrentElementProperties(this.threeLevelProperties);
                this.getPumpingBeam().setEnabled(true);
                break;
            }
            default: {
                throw new RuntimeException("Invalid number of levels");
            }
        }
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = (Atom)this.atoms.get(i);
            atom.setStates(this.getCurrentElementProperties().getStates());
        }
        this.numGroundStateAtoms = 0;
        this.numMiddleStateAtoms = 0;
        this.numHighStateAtoms = 0;
        LaserElementProperties laserElementProperties = (LaserElementProperties)this.getCurrentElementProperties();
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = (Atom)this.atoms.get(i);
            if (atom.getCurrState() == laserElementProperties.getGroundState()) {
                ++this.numGroundStateAtoms;
            }
            if (atom.getCurrState() == laserElementProperties.getMiddleEnergyState()) {
                ++this.numMiddleStateAtoms;
            }
            if (atom.getCurrState() != laserElementProperties.getHighEnergyState()) continue;
            ++this.numHighStateAtoms;
        }
        this.changeListenerProxy.atomicStatesChanged(new ChangeEvent(this));
    }

    public Tube getResonatingCavity() {
        return this.tube;
    }

    public Beam getSeedBeam() {
        return this.stimulatingBeam;
    }

    public void setStimulatingBeam(Beam beam) {
        if (beam != null) {
            this.removeModelElement(beam);
        }
        this.addModelElement(beam);
        this.stimulatingBeam = beam;
    }

    public Beam getPumpingBeam() {
        return this.pumpingBeam;
    }

    public void setPumpingBeam(Beam beam) {
        if (beam != null) {
            this.removeModelElement(beam);
        }
        this.addModelElement(beam);
        this.pumpingBeam = beam;
    }

    public int getNumGroundStateAtoms() {
        return this.numGroundStateAtoms;
    }

    public int getNumMiddleStateAtoms() {
        return this.numMiddleStateAtoms;
    }

    public int getNumHighStateAtoms() {
        return this.numHighStateAtoms;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.boundingRectangle.setRect(rectangle2D);
    }

    public AtomicState getMiddleEnergyState() {
        return this.getCurrentElementProperties().getStates()[1];
    }

    public AtomicState getHighEnergyState() {
        return ((LaserElementProperties)this.getCurrentElementProperties()).getHighEnergyState();
    }

    public AtomicState[] getStates() {
        return this.getCurrentElementProperties().getStates();
    }

    public int getNumLasingPhotons() {
        return this.lasingPhotons.size();
    }

    public MatchState getMatch(Beam beam) {
        AtomicState[] atomicStateArray = this.getStates();
        for (int i = 0; i < atomicStateArray.length; ++i) {
            AtomicState atomicState = atomicStateArray[i];
            EnergyMatchDetector energyMatchDetector = new EnergyMatchDetector(this, atomicState, beam);
            MatchState matchState = energyMatchDetector.getMatch();
            if (!matchState.isMatch()) continue;
            return matchState;
        }
        return null;
    }

    public void addLaserListener(ChangeListener changeListener) {
        this.laserEventChannel.addListener(changeListener);
    }

    public void leftSystemEventOccurred(Photon.LeftSystemEvent leftSystemEvent) {
        Photon photon = leftSystemEvent.getPhoton();
        if (this.lasingPhotons.contains(photon)) {
            this.lasingPhotons.remove(photon);
            this.changeListenerProxy.lasingPopulationChanged(new ChangeEvent(this));
        }
        super.leftSystemEventOccurred(leftSystemEvent);
    }

    private class AtomChangeListener
    extends Atom.ChangeListenerAdapter {
        private AtomChangeListener() {
        }

        public void stateChanged(Atom.ChangeEvent changeEvent) {
            AtomicState atomicState = changeEvent.getPrevState();
            AtomicState atomicState2 = changeEvent.getCurrState();
            LaserElementProperties laserElementProperties = (LaserElementProperties)LaserModel.this.getCurrentElementProperties();
            if (atomicState == laserElementProperties.getGroundState()) {
                LaserModel.this.numGroundStateAtoms--;
            }
            if (atomicState == laserElementProperties.getMiddleEnergyState()) {
                LaserModel.this.numMiddleStateAtoms--;
            }
            if (atomicState == laserElementProperties.getHighEnergyState()) {
                LaserModel.this.numHighStateAtoms--;
            }
            if (atomicState2 == laserElementProperties.getGroundState()) {
                LaserModel.this.numGroundStateAtoms++;
            }
            if (atomicState2 == laserElementProperties.getMiddleEnergyState()) {
                LaserModel.this.numMiddleStateAtoms++;
            }
            if (atomicState2 == laserElementProperties.getHighEnergyState()) {
                LaserModel.this.numHighStateAtoms++;
            }
        }
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Object object) {
            super(object);
        }

        public LaserModel getLaserModel() {
            return (LaserModel)this.getSource();
        }

        public int getLasingPopulation() {
            return LaserModel.this.lasingPhotons.size();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void lasingPopulationChanged(ChangeEvent var1);

        public void atomicStatesChanged(ChangeEvent var1);
    }

    public static class ChangeListenerAdapter
    implements ChangeListener {
        public void lasingPopulationChanged(ChangeEvent changeEvent) {
        }

        public void atomicStatesChanged(ChangeEvent changeEvent) {
        }
    }

    private class CollisionAgent
    implements ModelElement {
        PhotonAtomCollisonExpert photonAtomExpert = new PhotonAtomCollisonExpert();
        int numSections = 6;

        private CollisionAgent() {
        }

        public void stepInTime(double d) {
            block0: for (int i = 0; i < LaserModel.this.photons.size(); ++i) {
                Photon photon = (Photon)LaserModel.this.photons.get(i);
                if (photon instanceof Photon && !LaserModel.this.tube.getBounds().contains(photon.getPosition()) && !LaserModel.this.tube.getBounds().contains(photon.getPositionPrev())) continue;
                for (int j = 0; j < LaserModel.this.atoms.size(); ++j) {
                    Atom atom = (Atom)LaserModel.this.atoms.get(j);
                    AtomicState atomicState = atom.getCurrState();
                    this.photonAtomExpert.detectAndDoCollision(photon, atom);
                    AtomicState atomicState2 = atom.getCurrState();
                    if (atomicState != atomicState2) continue block0;
                }
            }
            LaserModel.this.collisionMechanism.doIt((List)LaserModel.this.photons, LaserModel.this.mirrors);
            LaserModel.this.collisionMechanism.doIt((List)LaserModel.this.atoms, LaserModel.this.tube);
        }
    }

    private class CollisionMechanism {
        private ArrayList collisionExperts = new ArrayList();

        private CollisionMechanism() {
        }

        void addCollisionExpert(CollisionExpert collisionExpert) {
            this.collisionExperts.add(collisionExpert);
        }

        void doIt(List list, List list2) {
            for (int i = 0; i < list.size(); ++i) {
                Collidable collidable = (Collidable)list.get(i);
                if (collidable instanceof Photon && !LaserModel.this.tube.getBounds().contains(((Photon)collidable).getPosition()) && !LaserModel.this.tube.getBounds().contains(collidable.getPositionPrev())) continue;
                for (int j = 0; j < list2.size(); ++j) {
                    Collidable collidable2 = (Collidable)list2.get(j);
                    if (collidable == collidable2 || collidable2 instanceof Photon && !LaserModel.this.tube.getBounds().contains(((Photon)collidable2).getPosition())) continue;
                    for (int k = 0; k < this.collisionExperts.size(); ++k) {
                        CollisionExpert collisionExpert = (CollisionExpert)this.collisionExperts.get(k);
                        collisionExpert.detectAndDoCollision(collidable, collidable2);
                    }
                }
            }
        }

        void doIt(List list, Collidable collidable) {
            for (int i = 0; i < list.size(); ++i) {
                Collidable collidable2 = (Collidable)list.get(i);
                if (collidable2 instanceof Photon && !LaserModel.this.tube.getBounds().contains(((Photon)collidable2).getPosition()) && !LaserModel.this.tube.getBounds().contains(collidable2.getPositionPrev())) continue;
                for (int j = 0; j < this.collisionExperts.size(); ++j) {
                    CollisionExpert collisionExpert = (CollisionExpert)this.collisionExperts.get(j);
                    collisionExpert.detectAndDoCollision(collidable2, collidable);
                }
            }
        }
    }
}

