/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.quantum.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.quantum.model.ElectromotiveForce;
import edu.colorado.phet.dischargelamps.quantum.model.Electron;
import edu.colorado.phet.dischargelamps.quantum.model.Plate;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Random;

public class ElectronSource
implements ModelElement {
    public static Object SINGLE_SHOT_MODE = new Object();
    public static Object CONTINUOUS_MODE = new Object();
    private static HashSet electronProductionModes = new HashSet();
    private Random random = new Random(System.currentTimeMillis());
    private double electronsPerSecond;
    private double timeSincelastElectronEmitted;
    private ElectromotiveForce emf;
    private Point2D p1;
    private Point2D p2;
    private Plate plate;
    private Object electronProductionMode;
    private EventChannel listenerChannel = new EventChannel(ElectronProductionListener.class);
    private ElectronProductionListener electronProductionListenerProxy = (ElectronProductionListener)this.listenerChannel.getListenerProxy();

    public ElectronSource(ElectromotiveForce electromotiveForce, Point2D point2D, Point2D point2D2, Plate plate) {
        this.emf = electromotiveForce;
        this.p1 = point2D;
        this.p2 = point2D2;
        this.plate = plate;
    }

    public void stepInTime(double d) {
        this.timeSincelastElectronEmitted += d;
        double d2 = 1.0 / this.electronsPerSecond;
        if (this.timeSincelastElectronEmitted > d2 && this.electronProductionMode == CONTINUOUS_MODE) {
            this.timeSincelastElectronEmitted = 0.0;
            this.produceElectron();
        }
    }

    public Electron produceElectron() {
        Electron electron = null;
        if (this.plate.getPotential() > 0.0) {
            electron = new Electron();
            double d = this.random.nextDouble() * (this.p2.getX() - this.p1.getX()) + this.p1.getX();
            double d2 = this.random.nextDouble() * (this.p2.getY() - this.p1.getY()) + this.p1.getY();
            MutableVector2D mutableVector2D = new MutableVector2D(this.emf.getElectronAcceleration());
            if (mutableVector2D.magnitude() > 0.0) {
                mutableVector2D.normalize().scale(2.0);
            }
            electron.setPosition(d + mutableVector2D.getX(), d2 + mutableVector2D.getY());
            this.electronProductionListenerProxy.electronProduced(new ElectronProductionEvent(this, electron));
        }
        return electron;
    }

    public void setElectronsPerSecond(double d) {
        this.electronsPerSecond = d;
    }

    public void setCurrent(double d) {
        this.setElectronsPerSecond(d);
    }

    public void setLength(double d) {
        double d2 = (this.p1.getX() + this.p2.getX()) / 2.0;
        double d3 = (this.p1.getY() + this.p2.getY()) / 2.0;
        double d4 = this.p1.distance(this.p2);
        double d5 = d / d4;
        this.p1.setLocation(d2 + (this.p1.getX() - d2) * d5, d3 + (this.p1.getY() - d3) * d5);
        this.p2.setLocation(d2 + (this.p2.getX() - d2) * d5, d3 + (this.p2.getY() - d3) * d5);
    }

    public void setElectronProductionMode(Object object) {
        if (!electronProductionModes.contains(object)) {
            throw new RuntimeException("Invalid parameter ");
        }
        this.electronProductionMode = object;
    }

    public void addListener(ElectronProductionListener electronProductionListener) {
        this.listenerChannel.addListener(electronProductionListener);
    }

    static {
        electronProductionModes.add(SINGLE_SHOT_MODE);
        electronProductionModes.add(CONTINUOUS_MODE);
    }

    public static class ElectronProductionEvent
    extends EventObject {
        private Electron electron;

        public ElectronProductionEvent(Object object, Electron electron) {
            super(object);
            this.electron = electron;
        }

        public Electron getElectron() {
            return this.electron;
        }
    }

    public static interface ElectronProductionListener
    extends EventListener {
        public void electronProduced(ElectronProductionEvent var1);
    }
}

