/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Random;

public class MathUtil {
    private static final Random random = new Random(System.currentTimeMillis());
    public static final double SQRT_2 = Math.sqrt(2.0);

    public static int getSign(double d) {
        if (d != 0.0 && !Double.isNaN(d) && !Double.isInfinite(d)) {
            return (int)(Math.abs(d) / d);
        }
        return 1;
    }

    public static double[] quadraticRoots(double[] dArray, double d, double d2, double d3) {
        double d4 = (float)Math.sqrt(d2 * d2 - 4.0 * d * d3);
        dArray[0] = (-d2 + d4) / (2.0 * d);
        dArray[1] = (-d2 - d4) / (2.0 * d);
        return dArray;
    }

    public static double[] quadraticRoots(double d, double d2, double d3) {
        double[] dArray = new double[2];
        return MathUtil.quadraticRoots(dArray, d, d2, d3);
    }

    public static boolean isApproxEqual(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    public static Point2D reflectPointAcrossLine(Point2D point2D, Point2D point2D2, double d) {
        double d2 = d % (Math.PI * 2);
        double d3 = Math.atan2(point2D.getY() - point2D2.getY(), point2D.getX() - point2D2.getX()) % (Math.PI * 2);
        double d4 = (2.0 * d2 - d3) % (Math.PI * 2);
        double d5 = point2D.distance(point2D2);
        return new Point2D.Double(point2D2.getX() + d5 * Math.cos(d4), point2D2.getY() + d5 * Math.sin(d4));
    }

    public static double clamp(double d, double d2, double d3) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d2 < d) {
            return d;
        }
        if (d2 > d3) {
            return d3;
        }
        return d2;
    }

    public static int clamp(int n, int n2, int n3) {
        if (n2 < n) {
            return n;
        }
        if (n2 > n3) {
            return n3;
        }
        return n2;
    }

    public static Point2D[] getLineCircleIntersection(Ellipse2D ellipse2D, Line2D line2D) {
        double d = ellipse2D.getCenterX();
        double d2 = ellipse2D.getCenterY();
        double d3 = line2D.getX1() - d;
        double d4 = line2D.getX2() - d;
        double d5 = line2D.getY1() - d2;
        double d6 = line2D.getY2() - d2;
        double d7 = ellipse2D.getWidth() / 2.0;
        double d8 = d4 - d3;
        double d9 = d6 - d5;
        double d10 = Math.sqrt(d8 * d8 + d9 * d9);
        double d11 = d3 * d6 - d4 * d5;
        double d12 = d7 * d7 * d10 * d10 - d11 * d11;
        double d13 = Math.sqrt(d12);
        double d14 = d11 * d9 - (double)MathUtil.getSign(d9) * d8 * d13;
        double d15 = d11 * d9 + (double)MathUtil.getSign(d9) * d8 * d13;
        double d16 = -d11 * d8 - Math.abs(d9) * d13;
        double d17 = -d11 * d8 + Math.abs(d9) * d13;
        Point2D[] point2DArray = new Point2D[2];
        if (d12 >= 0.0) {
            double d18 = d10 * d10;
            point2DArray[0] = new Point2D.Double(d + d14 / d18, d2 + d16 / d18);
            point2DArray[1] = new Point2D.Double(d + d15 / d18, d2 + d17 / d18);
        }
        return point2DArray;
    }

    public static long daysToMilliseconds(long l) {
        return l * 24L * 60L * 60L * 1000L;
    }
}

