/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view.phetgraphics;

import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class PhetShapeGraphic
extends PhetGraphic {
    private Shape shape;
    private Stroke stroke;
    private Paint fill;
    private Paint border;
    private Composite orgComposite = null;
    private Paint workingPaint;
    private Shape strokedShape;
    private boolean shapeDirty = false;

    public PhetShapeGraphic(Component component, Shape shape, Paint paint, Stroke stroke, Paint paint2) {
        super(component);
        this.shape = shape;
        this.fill = paint;
        this.stroke = stroke;
        this.border = paint2;
        this.computeStrokedShape();
    }

    public PhetShapeGraphic(Component component, Shape shape, Paint paint) {
        this(component, shape, paint, null, null);
    }

    public void setShape(Shape shape) {
        boolean bl = this.sameShape(this.shape, shape);
        if (!bl) {
            this.shape = shape;
            this.setShapeDirty();
        }
    }

    public void setShapeDirty() {
        this.shapeDirty = true;
        this.setBoundsDirty();
        this.autorepaint();
    }

    public void setBorderColor(Color color) {
        this.border = color;
        this.autorepaint();
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.setShapeDirty();
    }

    public void setPaint(Paint paint) {
        boolean bl = false;
        if (this.fill == null && paint != null) {
            bl = true;
        } else if (this.fill != null && paint == null) {
            bl = true;
        } else if (this.fill == null && paint == null) {
            bl = false;
        } else if (!this.fill.equals(paint)) {
            bl = true;
        }
        if (bl) {
            this.fill = paint;
            this.autorepaint();
        }
    }

    private void computeStrokedShape() {
        this.strokedShape = this.stroke != null && this.shape != null ? this.stroke.createStrokedShape(this.shape) : null;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.saveGraphicsState(graphics2D);
            super.updateGraphicsState(graphics2D);
            if (this.shape != null) {
                graphics2D.transform(this.getNetTransform());
                if (this.fill != null) {
                    this.workingPaint = this.fill;
                    this.setAlpha(graphics2D, this.fill);
                    graphics2D.setPaint(this.workingPaint);
                    graphics2D.fill(this.shape);
                    this.restoreAlpha(graphics2D);
                }
                if (this.stroke != null) {
                    this.workingPaint = this.fill;
                    this.setAlpha(graphics2D, this.border);
                    graphics2D.setPaint(this.workingPaint);
                    Stroke stroke = graphics2D.getStroke();
                    graphics2D.setStroke(this.stroke);
                    graphics2D.draw(this.shape);
                    graphics2D.setStroke(stroke);
                    this.restoreAlpha(graphics2D);
                }
            }
            super.restoreGraphicsState();
        }
    }

    private void restoreAlpha(Graphics2D graphics2D) {
        if (this.orgComposite != null) {
            graphics2D.setComposite(this.orgComposite);
            this.orgComposite = null;
        }
    }

    private void setAlpha(Graphics2D graphics2D, Paint paint) {
        Color color;
        ApparatusPanel2 apparatusPanel2;
        Component component = this.getComponent();
        this.workingPaint = paint;
        if (component instanceof ApparatusPanel2 && (apparatusPanel2 = (ApparatusPanel2)component).isUseOffscreenBuffer() && paint instanceof Color && (color = (Color)paint).getAlpha() < 255) {
            this.workingPaint = new Color(color.getRed(), color.getGreen(), color.getBlue());
            double d = (double)color.getAlpha() / 255.0;
            Composite composite = graphics2D.getComposite();
            if (composite instanceof AlphaComposite) {
                AlphaComposite alphaComposite = (AlphaComposite)composite;
                d *= (double)alphaComposite.getAlpha();
            }
            this.orgComposite = graphics2D.getComposite();
            GraphicsUtil.setAlpha(graphics2D, d);
        }
    }

    protected Rectangle determineBounds() {
        if (this.shape == null) {
            return null;
        }
        if (this.stroke == null) {
            return this.getNetTransform().createTransformedShape(this.shape.getBounds()).getBounds();
        }
        this.synchronizeStrokedShape();
        Rectangle rectangle = this.strokedShape.getBounds();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        return this.getNetTransform().createTransformedShape(rectangle2).getBounds();
    }

    private void synchronizeStrokedShape() {
        if (this.shapeDirty) {
            this.computeStrokedShape();
            this.shapeDirty = false;
        }
    }

    private boolean sameShape(Shape shape, Shape shape2) {
        if (shape == null && shape2 == null) {
            return true;
        }
        if (shape == null && shape2 != null) {
            return false;
        }
        if (shape != null && shape2 == null) {
            return false;
        }
        if (shape.equals(shape2)) {
            return true;
        }
        if (new GeneralPathComparator().isMatch(shape, shape2)) {
            return true;
        }
        return new Rectangle2DComparator().isMatch(shape, shape2);
    }

    public boolean contains(int n, int n2) {
        if (this.isVisible() && this.shape != null) {
            boolean bl;
            boolean bl2 = this.stroke != null && this.border != null;
            boolean bl3 = bl = this.fill != null;
            if (bl && this.shapeContains(n, n2)) {
                return true;
            }
            if (bl2 && this.borderContains(n, n2)) {
                return true;
            }
        }
        return false;
    }

    private boolean borderContains(int n, int n2) {
        boolean bl = false;
        this.synchronizeStrokedShape();
        if (this.strokedShape != null) {
            Shape shape = this.getNetTransform().createTransformedShape(this.strokedShape);
            bl = shape.contains(n, n2);
        }
        return bl;
    }

    private boolean shapeContains(int n, int n2) {
        boolean bl = false;
        if (this.shape != null) {
            Shape shape = this.getNetTransform().createTransformedShape(this.shape);
            bl = shape.contains(n, n2);
        }
        return bl;
    }

    private static class GeneralPathComparator {
        private GeneralPathComparator() {
        }

        public boolean isMatch(Shape shape, Shape shape2) {
            Area area;
            Area area2;
            return shape.getClass().equals(GeneralPath.class) && shape2.getClass().equals(GeneralPath.class) && (area2 = new Area(shape)).equals(area = new Area(shape2));
        }
    }

    private static class Rectangle2DComparator {
        private Rectangle2DComparator() {
        }

        public boolean isMatch(Shape shape, Shape shape2) {
            if (shape.getClass().equals(Rectangle2D.Double.class) && shape2.getClass().equals(Rectangle2D.Double.class)) {
                Rectangle2D.Double double_ = (Rectangle2D.Double)shape;
                Rectangle2D.Double double_2 = (Rectangle2D.Double)shape2;
                boolean bl = double_.x == double_2.x && double_.y == double_2.y && double_.width == double_2.width && double_.height == double_2.height;
                return bl;
            }
            return false;
        }
    }
}

