/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.Color;

public class VisibleColor
extends Color {
    public static final VisibleColor RED = new VisibleColor(Color.RED);
    public static final VisibleColor GREEN = new VisibleColor(Color.GREEN);
    public static final VisibleColor BLUE = new VisibleColor(Color.BLUE);
    public static final VisibleColor WHITE = new VisibleColor(0.0);
    public static final VisibleColor INVISIBLE = new VisibleColor(0, 0, 0, 0);
    public static final Color COLOR_INVISIBLE = new Color(0, 0, 0, 0);
    private static Color[] _colorLookup = null;
    private double _wavelength = VisibleColor.colorToWavelength(this);

    public VisibleColor(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public VisibleColor(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public VisibleColor(double d) {
        this(VisibleColor.wavelengthToColor(d));
    }

    public double getWavelength() {
        return this._wavelength;
    }

    public Color toColor() {
        return new Color(this.getRed(), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public String toString() {
        return "VisibleColor: RGBA=" + this.getRed() + "-" + this.getGreen() + "-" + this.getBlue() + "-" + this.getAlpha() + ", wavelength=" + this._wavelength;
    }

    public static Color wavelengthToColor(double d) {
        return VisibleColor.wavelengthToColor(d, COLOR_INVISIBLE, COLOR_INVISIBLE);
    }

    public static Color wavelengthToColor(double d, Color color, Color color2) {
        Color color3 = null;
        if (d == 0.0) {
            color3 = Color.WHITE;
        } else if (d < 380.0) {
            color3 = color;
        } else if (d > 780.0) {
            color3 = color2;
        } else {
            if (_colorLookup == null) {
                VisibleColor.initColorLookup();
            }
            color3 = _colorLookup[(int)(d - 380.0)];
        }
        return color3;
    }

    public static double colorToWavelength(Color color) {
        double d = 781.0;
        if (_colorLookup == null) {
            VisibleColor.initColorLookup();
        }
        if (color.equals(Color.WHITE)) {
            return 0.0;
        }
        for (int i = 0; i < _colorLookup.length; ++i) {
            if (Math.abs(color.getRed() - _colorLookup[i].getRed()) >= 2 || Math.abs(color.getGreen() - _colorLookup[i].getGreen()) >= 2 || Math.abs(color.getBlue() - _colorLookup[i].getBlue()) >= 2) continue;
            d = 380.0 + (double)i;
            break;
        }
        return d;
    }

    private static void initColorLookup() {
        int n = 401;
        _colorLookup = new Color[n];
        for (int i = 0; i < n; ++i) {
            double d = 380.0 + (double)i;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            if (d >= 380.0 && d <= 440.0) {
                d4 = -1.0 * (d - 440.0) / 60.0;
                d3 = 0.0;
                d2 = 1.0;
            } else if (d > 440.0 && d <= 490.0) {
                d4 = 0.0;
                d3 = (d - 440.0) / 50.0;
                d2 = 1.0;
            } else if (d > 490.0 && d <= 510.0) {
                d4 = 0.0;
                d3 = 1.0;
                d2 = -1.0 * (d - 510.0) / 20.0;
            } else if (d > 510.0 && d <= 580.0) {
                d4 = (d - 510.0) / 70.0;
                d3 = 1.0;
                d2 = 0.0;
            } else if (d > 580.0 && d <= 645.0) {
                d4 = 1.0;
                d3 = -1.0 * (d - 645.0) / 65.0;
                d2 = 0.0;
            } else if (d > 645.0 && d <= 780.0) {
                d4 = 1.0;
                d3 = 0.0;
                d2 = 0.0;
            }
            double d5 = d > 645.0 ? 0.3 + 0.7 * (780.0 - d) / 135.0 : (d < 420.0 ? 0.3 + 0.7 * (d - 380.0) / 40.0 : 1.0);
            int n2 = (int)Math.round(255.0 * (d5 * d4));
            int n3 = (int)Math.round(255.0 * (d5 * d3));
            int n4 = (int)Math.round(255.0 * (d5 * d2));
            int n5 = 255;
            VisibleColor._colorLookup[i] = new Color(n2, n3, n4, n5);
        }
    }
}

