/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.view;

import edu.colorado.phet.colorvision.model.Photon;
import edu.colorado.phet.colorvision.model.PhotonBeam;
import edu.colorado.phet.colorvision.view.BoundsOutliner;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;

public class PhotonBeamGraphic
extends PhetGraphic
implements SimpleObserver {
    private static Stroke PHOTON_STROKE = new BasicStroke(1.0f);
    private PhotonBeam _photonBeamModel;

    public PhotonBeamGraphic(Component component, PhotonBeam photonBeam) {
        super(component);
        this._photonBeamModel = photonBeam;
    }

    protected Rectangle determineBounds() {
        return this._photonBeamModel.getBounds();
    }

    public void update() {
        super.repaint();
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible() && this._photonBeamModel.isEnabled()) {
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(PHOTON_STROKE);
            Photon photon = null;
            ArrayList arrayList = this._photonBeamModel.getPhotons();
            for (int i = 0; i < arrayList.size(); ++i) {
                photon = (Photon)arrayList.get(i);
                if (!photon.isInUse()) continue;
                Color color = null;
                if (photon.getIntensity() == 0.0) {
                    color = VisibleColor.INVISIBLE.toColor();
                } else if (photon.getColor().getWavelength() == 0.0) {
                    double d = this.genWavelength();
                    color = VisibleColor.wavelengthToColor(d);
                } else {
                    color = photon.getColor().toColor();
                }
                graphics2D.setPaint(color);
                int n = (int)photon.getX();
                int n2 = (int)photon.getY();
                int n3 = (int)photon.getWidth();
                int n4 = (int)photon.getHeight();
                graphics2D.drawLine(n, n2, n - n3, n2 - n4);
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            BoundsOutliner.paint(graphics2D, this, Color.YELLOW);
        }
    }

    private double genWavelength() {
        double d = 400.0;
        return Math.random() * d + 380.0;
    }
}

