/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.model;

import edu.colorado.phet.colorvision.event.VisibleColorChangeEvent;
import edu.colorado.phet.colorvision.event.VisibleColorChangeListener;
import edu.colorado.phet.colorvision.model.Filter;
import edu.colorado.phet.colorvision.model.Spotlight;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import javax.swing.event.EventListenerList;

public class SolidBeam
extends SimpleObservable
implements SimpleObserver {
    private Spotlight _spotlightModel;
    private Filter _filterModel;
    private int _distance;
    private EventListenerList _listenerList;
    private boolean _enabled;
    private VisibleColor _perceivedColor;

    public SolidBeam(Spotlight spotlight, Filter filter) {
        this._spotlightModel = spotlight;
        this._filterModel = filter;
        this._distance = 0;
        this._listenerList = new EventListenerList();
        this._enabled = true;
        this._perceivedColor = VisibleColor.INVISIBLE;
    }

    public SolidBeam(Spotlight spotlight) {
        this(spotlight, null);
    }

    public void setDistance(int n) {
        this._distance = n;
        this.update();
    }

    public int getDistance() {
        return this._distance;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
        this.notifyObservers();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public VisibleColor getPerceivedColor() {
        return this._perceivedColor;
    }

    public double getDirection() {
        return this._spotlightModel.getDirection();
    }

    public double getCutOffAngle() {
        return this._spotlightModel.getCutOffAngle();
    }

    public double getX() {
        return this._spotlightModel.getX();
    }

    public double getY() {
        return this._spotlightModel.getY();
    }

    public void update() {
        VisibleColor visibleColor;
        VisibleColor visibleColor2 = visibleColor = this._spotlightModel.getColor();
        if (this._filterModel != null) {
            visibleColor2 = this._filterModel.colorPassed(visibleColor);
        }
        if (this._enabled && !visibleColor2.equals(this._perceivedColor)) {
            VisibleColorChangeEvent visibleColorChangeEvent = new VisibleColorChangeEvent(this, visibleColor2);
            this.fireColorChangeEvent(visibleColorChangeEvent);
        }
        this._perceivedColor = visibleColor2;
        this.notifyObservers();
    }

    public void addColorChangeListener(VisibleColorChangeListener visibleColorChangeListener) {
        this._listenerList.add(VisibleColorChangeListener.class, visibleColorChangeListener);
    }

    private void fireColorChangeEvent(VisibleColorChangeEvent visibleColorChangeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != VisibleColorChangeListener.class) continue;
            ((VisibleColorChangeListener)objectArray[i + 1]).colorChanged(visibleColorChangeEvent);
        }
    }
}

