/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.model;

import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;

public class Photon {
    private double _x;
    private double _y;
    private double _direction;
    private VisibleColor _color;
    private double _intensity;
    private boolean _inUse = true;
    private boolean _isFiltered;
    private double _deltaX;
    private double _deltaY;
    private double _width;
    private double _height;

    public Photon(VisibleColor visibleColor, double d, double d2, double d3, double d4) {
        this._color = visibleColor;
        this._intensity = d;
        this._x = d2;
        this._y = d3;
        this._isFiltered = false;
        this.setDirection(d4);
    }

    public void setInUse(boolean bl) {
        this._inUse = bl;
    }

    public boolean isInUse() {
        return this._inUse;
    }

    public void setFiltered(boolean bl) {
        this._isFiltered = bl;
    }

    public boolean isFiltered() {
        return this._isFiltered;
    }

    public void setLocation(double d, double d2) {
        this._x = d;
        this._y = d2;
    }

    public double getX() {
        return this._x;
    }

    public double getY() {
        return this._y;
    }

    public void setDirection(double d) {
        this._direction = d;
        double d2 = Math.toRadians(d);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        this._deltaX = 10.0 * d3;
        this._deltaY = 10.0 * d4;
        this._width = 3.0 * d3;
        this._height = 3.0 * d4;
    }

    public void setColor(VisibleColor visibleColor) {
        this._color = visibleColor;
    }

    public VisibleColor getColor() {
        return this._color;
    }

    public void setIntensity(double d) {
        if (d < 0.0 || d > 100.0) {
            throw new IllegalArgumentException("intensity out of range: " + d);
        }
        this._intensity = d;
    }

    public double getIntensity() {
        return this._intensity;
    }

    public double getWidth() {
        return this._width;
    }

    public double getHeight() {
        return this._height;
    }

    public void stepInTime(double d) {
        this._x += this._deltaX;
        this._y += this._deltaY;
    }
}

