/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.config;

import java.util.Properties;
import org.jfree.base.config.ModifiableConfiguration;
import org.jfree.util.Configuration;
import org.jfree.util.PublicCloneable;

public class HierarchicalConfiguration
implements ModifiableConfiguration,
PublicCloneable {
    private Properties configuration = new Properties();
    private transient Configuration parentConfiguration;

    public String getConfigProperty(String key, String defaultValue) {
        String value = this.configuration.getProperty(key);
        if (value == null) {
            value = this.isRootConfig() ? defaultValue : this.parentConfiguration.getConfigProperty(key, defaultValue);
        }
        return value;
    }

    private boolean isRootConfig() {
        return this.parentConfiguration == null;
    }

    protected Properties getConfiguration() {
        return this.configuration;
    }

    public void insertConfiguration(HierarchicalConfiguration config) {
        config.setParentConfig(this.getParentConfig());
        this.setParentConfig(config);
    }

    protected void setParentConfig(Configuration config) {
        if (this.parentConfiguration == this) {
            throw new IllegalArgumentException("Cannot add myself as parent configuration.");
        }
        this.parentConfiguration = config;
    }

    protected Configuration getParentConfig() {
        return this.parentConfiguration;
    }

    public Object clone() throws CloneNotSupportedException {
        HierarchicalConfiguration config = (HierarchicalConfiguration)super.clone();
        config.configuration = (Properties)this.configuration.clone();
        return config;
    }
}

