/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Switch;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.BranchNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.BranchNodeFactory;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKSimulationPanel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ClipFactory;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ElectronNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ElectronSetNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.JunctionNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ReadoutSetNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.SolderNode;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import javax.swing.JComponent;

public class CircuitNode
extends PhetPNode {
    private CCKModel cckModel;
    private Circuit circuit;
    private Component component;
    private CCKModule module;
    private BooleanProperty readoutsVisibleProperty;
    private ReadoutSetNode readoutLayer;
    private PNode electronLayer;
    private PNode solderLayer;
    private PNode branchLayer;
    private PNode junctionLayer;
    private ClipFactory clipFactory;
    private BranchNodeFactory branchNodeFactory;
    private boolean changingLifelike;
    private ReadoutSetNode editingReadoutLayer;

    public CircuitNode(final CCKModel cCKModel, final Circuit circuit, final JComponent jComponent, CCKModule cCKModule, BranchNodeFactory branchNodeFactory, BooleanProperty booleanProperty, final BooleanProperty booleanProperty2) {
        this.branchNodeFactory = branchNodeFactory;
        this.cckModel = cCKModel;
        this.circuit = circuit;
        this.component = jComponent;
        this.module = cCKModule;
        this.readoutsVisibleProperty = booleanProperty;
        this.solderLayer = new PNode();
        this.branchLayer = new PNode();
        this.junctionLayer = new PNode();
        this.clipFactory = new ClipFactory(){

            public Shape getClip(ElectronNode electronNode) {
                if (!CircuitNode.this.changingLifelike) {
                    Branch branch = electronNode.getElectron().getBranch();
                    BranchNode branchNode = CircuitNode.this.getNode(branch);
                    if (branchNode == null) {
                        new RuntimeException("Null node for branch: " + branch).printStackTrace();
                        return null;
                    }
                    return branchNode.getClipShape(CircuitNode.this.electronLayer.getParent());
                }
                return null;
            }
        };
        this.electronLayer = new ElectronSetNode(this, cCKModel);
        this.readoutLayer = new ReadoutSetNode(cCKModule, circuit);
        this.editingReadoutLayer = new ReadoutSetNode(cCKModule, circuit);
        this.addChild(this.solderLayer);
        this.addChild(this.branchLayer);
        this.addChild(this.junctionLayer);
        this.addChild(this.electronLayer);
        this.addChild(this.readoutLayer);
        this.addChild(this.editingReadoutLayer);
        circuit.addCircuitListener(new CircuitListenerAdapter(){

            public void branchAdded(Branch branch) {
                CircuitNode.this.addBranchNode(branch);
            }

            public void junctionAdded(final Junction junction) {
                final SolderNode solderNode = new SolderNode(circuit, junction, Color.gray);
                CircuitNode.this.solderLayer.addChild(solderNode);
                final JunctionNode junctionNode = new JunctionNode(cCKModel, junction, CircuitNode.this, jComponent);
                CircuitNode.this.junctionLayer.addChild(junctionNode);
                CircuitListenerAdapter circuitListenerAdapter = new CircuitListenerAdapter(){

                    public void junctionRemoved(Junction junction2) {
                        if (junction2 == junction) {
                            CircuitNode.this.junctionLayer.removeChild(junctionNode);
                            CircuitNode.this.solderLayer.removeChild(solderNode);
                        }
                    }
                };
                circuit.addCircuitListener(circuitListenerAdapter);
            }

            public void selectionChanged() {
                CircuitNode.this.updateBranchOrder();
            }

            public void branchRemoved(Branch branch) {
                CircuitNode.this.removeBranchNode(branch);
            }
        });
        booleanProperty.addObserver(new SimpleObserver(){

            public void update() {
                CircuitNode.this.updateReadoutsVisible();
            }
        });
        booleanProperty2.addObserver(new SimpleObserver(){

            public void update() {
                Cloneable cloneable;
                int n;
                CircuitNode.this.changingLifelike = true;
                Branch[] branchArray = CircuitNode.this.getBranchOrder();
                CircuitNode.this.removeBranchGraphics();
                for (n = 0; n < branchArray.length; ++n) {
                    cloneable = branchArray[n];
                    if (cloneable instanceof Wire) {
                        Wire wire = (Wire)cloneable;
                        wire.setThickness((Boolean)booleanProperty2.get() != false ? 0.32789999999999997 : 0.19673999999999997);
                    }
                    CircuitNode.this.addBranchNode((Branch)cloneable);
                }
                CircuitNode.this.changingLifelike = false;
                for (n = 0; n < CircuitNode.this.electronLayer.getChildrenCount(); ++n) {
                    cloneable = (ElectronNode)CircuitNode.this.electronLayer.getChild(n);
                    ((ElectronNode)cloneable).update();
                }
            }
        });
    }

    private void removeBranchNode(Branch branch) {
        for (int i = 0; i < this.branchLayer.getChildrenCount(); ++i) {
            BranchNode branchNode = (BranchNode)this.branchLayer.getChild(i);
            if (branchNode.getBranch() != branch) continue;
            this.removeBranchGraphic(branchNode);
            --i;
        }
        this.updateBranchOrder();
    }

    private void updateBranchOrder() {
        this.moveSwitchesToFront();
        this.moveSelectedBranchesToFront();
    }

    private void moveSwitchesToFront() {
        for (int i = 0; i < this.branchLayer.getChildrenCount(); ++i) {
            BranchNode branchNode = (BranchNode)this.branchLayer.getChild(i);
            if (!(branchNode.getBranch() instanceof Switch)) continue;
            branchNode.moveToFront();
        }
    }

    private void moveSelectedBranchesToFront() {
        for (int i = 0; i < this.branchLayer.getChildrenCount(); ++i) {
            BranchNode branchNode = (BranchNode)this.branchLayer.getChild(i);
            if (!branchNode.getBranch().isSelected()) continue;
            branchNode.moveToFront();
        }
    }

    private void addBranchNode(Branch branch) {
        this.branchLayer.addChild(this.createNode(branch));
        this.updateBranchOrder();
        this.updateReadoutsVisible();
    }

    private BranchNode createNode(Branch branch) {
        return this.branchNodeFactory.createNode(branch);
    }

    private BranchNode getNode(Branch branch) {
        for (int i = 0; i < this.branchLayer.getChildrenCount(); ++i) {
            if (((BranchNode)this.branchLayer.getChild(i)).getBranch() != branch) continue;
            return (BranchNode)this.branchLayer.getChild(i);
        }
        return null;
    }

    private void removeBranchGraphic(BranchNode branchNode) {
        this.branchLayer.removeChild(branchNode);
    }

    public Circuit getCircuit() {
        return this.cckModel.getCircuit();
    }

    public boolean isElectronsVisible() {
        return this.electronLayer.getVisible();
    }

    public void setElectronsVisible(boolean bl) {
        this.electronLayer.setVisible(bl);
    }

    private void updateReadoutsVisible() {
        this.readoutLayer.setVisible((Boolean)this.readoutsVisibleProperty.get());
        this.readoutLayer.setAllReadoutsVisible((Boolean)this.readoutsVisibleProperty.get());
    }

    public ClipFactory getClipFactory() {
        return this.clipFactory;
    }

    public int getNumJunctionNodes() {
        return this.junctionLayer.getChildrenCount();
    }

    public JunctionNode getJunctionNode(int n) {
        return (JunctionNode)this.junctionLayer.getChild(n);
    }

    public int getNumBranchNodes() {
        return this.branchLayer.getChildrenCount();
    }

    public BranchNode getBranchNode(int n) {
        return (BranchNode)this.branchLayer.getChild(n);
    }

    private void removeBranchGraphics() {
        while (this.getNumBranchNodes() > 0) {
            this.removeBranchNode(0);
        }
    }

    private void removeBranchNode(int n) {
        BranchNode branchNode = (BranchNode)this.branchLayer.getChild(n);
        branchNode.delete();
        this.branchLayer.removeChild(n);
    }

    private Branch[] getBranchOrder() {
        ArrayList<Branch> arrayList = new ArrayList<Branch>();
        for (int i = 0; i < this.getNumBranchNodes(); ++i) {
            arrayList.add(this.getBranchNode(i).getBranch());
        }
        return arrayList.toArray(new Branch[0]);
    }

    public AffineTransform getTransformForZoom(double d, CCKSimulationPanel cCKSimulationPanel) {
        double d2 = 1.0 / d;
        PAffineTransform pAffineTransform = this.getTransform();
        this.setScale(1.0);
        this.setOffset(0.0, 0.0);
        this.scaleAboutPoint(d2, 5.0, 5.0);
        PAffineTransform pAffineTransform2 = this.getTransform();
        this.setTransform(pAffineTransform);
        return pAffineTransform2;
    }

    public boolean isReadoutVisible(Branch branch) {
        return this.readoutLayer.isReadoutVisible(branch);
    }

    public void addBranchNodeFactoryListener(BranchNodeFactory.Listener listener) {
        this.branchNodeFactory.addListener(listener);
    }
}

