/*
 * Decompiled with CFR 0.152.
 */
package scala;

import scala.Collection$class;
import scala.Function1;
import scala.Function1$class;
import scala.Iterable$Projection$class;
import scala.Iterable$class;
import scala.Iterator;
import scala.PartialFunction$class;
import scala.Predef$;
import scala.RandomAccessSeq;
import scala.RandomAccessSeq$Projection$class;
import scala.RandomAccessSeq$class;
import scala.Seq$Projection$class;
import scala.Seq$class;
import scala.StringBuilder;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;

public class Range
implements RandomAccessSeq.Projection {
    public volatile int bitmap$0;
    private int length;
    private final int step;
    private final int end;
    private final int start;

    public Range(int start, int end, int step) {
        this.start = start;
        this.end = end;
        this.step = step;
        Function1$class.$init$(this);
        PartialFunction$class.$init$(this);
        Iterable$class.$init$(this);
        Collection$class.$init$(this);
        Seq$class.$init$(this);
        Iterable$Projection$class.$init$(this);
        Seq$Projection$class.$init$(this);
        RandomAccessSeq$class.$init$(this);
        RandomAccessSeq$Projection$class.$init$(this);
        if (step == 0) {
            throw new IllegalArgumentException();
        }
    }

    public Object apply(Object x$1) {
        return BoxesRunTime.boxToInteger(this.apply(BoxesRunTime.unboxToInt(x$1)));
    }

    public boolean inInterval(int x) {
        return this.step() > 0 ? x >= this.start() && x < this.end() : x <= this.start() && x > this.end();
    }

    public int apply(int idx) {
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.start() + this.step() * idx;
    }

    public int last(int base, int step) {
        return base % step != 0 ? 1 : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int length() {
        if ((this.bitmap$0 & 1) != 0) return this.length;
        Range range = this;
        synchronized (range) {
            if ((this.bitmap$0 & 1) == 0) {
                int n;
                if (this.start() < this.end() && this.step() < 0) {
                    n = 0;
                } else if (this.start() > this.end() && this.step() > 0) {
                    n = 0;
                } else {
                    int base = this.start() < this.end() ? this.end() - this.start() : this.start() - this.end();
                    Predef$.MODULE$.assert(base >= 0);
                    int step = this.step() < 0 ? -this.step() : this.step();
                    Predef$.MODULE$.assert(step >= 0);
                    n = base / step + this.last(base, step);
                }
                this.length = n;
                this.bitmap$0 |= 1;
            }
            return this.length;
        }
    }

    public void foreach(Function1 f) {
        if (this.step() > 0) {
            int until;
            int n = until = this.inInterval(this.end()) ? this.end() + 1 : this.end();
            for (int i = this.start(); i < until; i += this.step()) {
                f.apply(BoxesRunTime.boxToInteger(i));
            }
        } else {
            int until;
            int n = until = this.inInterval(this.end()) ? this.end() - 1 : this.end();
            for (int i = this.start(); i > until; i += this.step()) {
                f.apply(BoxesRunTime.boxToInteger(i));
            }
        }
    }

    public int step() {
        return this.step;
    }

    public int end() {
        return this.end;
    }

    public int start() {
        return this.start;
    }

    public void copyToArray(BoxedArray x$1, int x$2) {
        Iterable$class.copyToArray(this, x$1, x$2);
    }

    public StringBuilder addString(StringBuilder x$1, String x$2, String x$3, String x$4) {
        return Iterable$class.addString(this, x$1, x$2, x$3, x$4);
    }

    public String mkString(String x$1, String x$2, String x$3) {
        return Iterable$class.mkString(this, x$1, x$2, x$3);
    }

    public void copyToBuffer(Buffer x$1) {
        Iterable$class.copyToBuffer(this, x$1);
    }

    public String stringPrefix() {
        return Collection$class.stringPrefix(this);
    }

    public String toString() {
        return Collection$class.toString(this);
    }

    public BoxedArray toArray() {
        return Seq$class.toArray(this);
    }

    public boolean isEmpty() {
        return Seq$class.isEmpty(this);
    }

    public Iterator elements() {
        return RandomAccessSeq$class.elements(this);
    }

    public RandomAccessSeq.Projection map(Function1 x$1) {
        return RandomAccessSeq$Projection$class.map(this, x$1);
    }

    public static class Inclusive
    extends Range {
        public Inclusive(int start, int end, int step) {
            super(start, end, step);
        }

        public Object apply(Object x$1) {
            return BoxesRunTime.boxToInteger(this.apply(BoxesRunTime.unboxToInt(x$1)));
        }

        public boolean inInterval(int x) {
            return super.step() > 0 ? x >= super.start() && x <= super.end() : x <= super.start() && x >= super.end();
        }

        public int last(int base, int step) {
            return 1;
        }

        public int apply(int idx) {
            return super.apply(idx);
        }
    }
}

