/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public class PActivityScheduler {
    private PRoot root;
    private List activities;
    private Timer activityTimer;
    private boolean activitiesChanged;
    private boolean animating;
    private ArrayList processingActivities;

    public PActivityScheduler(PRoot pRoot) {
        this.root = pRoot;
        this.activities = new ArrayList();
        this.processingActivities = new ArrayList();
    }

    public void addActivity(PActivity pActivity) {
        this.addActivity(pActivity, false);
    }

    public void addActivity(PActivity pActivity, boolean bl) {
        if (this.activities.contains(pActivity)) {
            return;
        }
        this.activitiesChanged = true;
        if (bl) {
            this.activities.add(0, pActivity);
        } else {
            this.activities.add(pActivity);
        }
        pActivity.setActivityScheduler(this);
        if (!this.getActivityTimer().isRunning()) {
            this.startActivityTimer();
        }
    }

    public void removeActivity(PActivity pActivity) {
        if (!this.activities.contains(pActivity)) {
            return;
        }
        this.activitiesChanged = true;
        this.activities.remove(pActivity);
        if (this.activities.size() == 0) {
            this.stopActivityTimer();
        }
    }

    public void processActivities(long l) {
        int n = this.activities.size();
        if (n > 0) {
            this.processingActivities.clear();
            this.processingActivities.addAll(this.activities);
            for (int i = n - 1; i >= 0; --i) {
                PActivity pActivity = (PActivity)this.processingActivities.get(i);
                pActivity.processStep(l);
            }
        }
    }

    public boolean getAnimating() {
        if (this.activitiesChanged) {
            this.animating = false;
            for (int i = 0; i < this.activities.size(); ++i) {
                PActivity pActivity = (PActivity)this.activities.get(i);
                this.animating |= pActivity.isAnimation();
            }
            this.activitiesChanged = false;
        }
        return this.animating;
    }

    protected void startActivityTimer() {
        this.getActivityTimer().start();
    }

    protected void stopActivityTimer() {
        this.getActivityTimer().stop();
    }

    protected Timer getActivityTimer() {
        if (this.activityTimer == null) {
            this.activityTimer = this.root.createTimer(PUtil.ACTIVITY_SCHEDULER_FRAME_DELAY, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PActivityScheduler.this.root.processInputs();
                }
            });
        }
        return this.activityTimer;
    }
}

