/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.statistics;

import edu.colorado.phet.common.phetcommon.statistics.StatisticsMessage;
import edu.colorado.phet.common.phetcommon.util.logging.USLogger;
import edu.colorado.phet.common.phetcommon.view.util.XMLUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.UnknownHostException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class StatisticsMessageSender {
    static /* synthetic */ Class class$edu$colorado$phet$common$phetcommon$statistics$StatisticsMessageSender;

    public boolean sendMessage(StatisticsMessage statisticsMessage) {
        boolean bl = false;
        try {
            Document document = StatisticsMessageSender.toDocument(statisticsMessage);
            HttpURLConnection httpURLConnection = this.postDocument(document);
            Document document2 = XMLUtils.readDocument(httpURLConnection);
            bl = this.parseResponse(document2);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println(this.getClass().getName() + ": cannot connect, " + unknownHostException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            transformerException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        return bl;
    }

    private static Document toDocument(StatisticsMessage statisticsMessage) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("submit_message");
        document.appendChild(element);
        Element element2 = document.createElement("statistics_message");
        for (int i = 0; i < statisticsMessage.getFieldCount(); ++i) {
            element2.setAttribute(statisticsMessage.getField(i).getName(), statisticsMessage.getField(i).getValue());
        }
        element.appendChild(element2);
        return document;
    }

    private HttpURLConnection postDocument(Document document) throws ParserConfigurationException, TransformerException, IOException {
        USLogger.log(this.getClass().getName() + " posting to url=" + "http://phet.colorado.edu/statistics/submit_message");
        USLogger.log(this.getClass().getName() + " query=\n" + XMLUtils.toString(document));
        return XMLUtils.post("http://phet.colorado.edu/statistics/submit_message", document);
    }

    private boolean parseResponse(Document document) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Object object;
        USLogger.log(this.getClass().getName() + " response=\n" + XMLUtils.toString(document));
        NodeList nodeList = document.getElementsByTagName("warning");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            object = element.getChildNodes();
            for (int j = 0; j < object.getLength(); ++j) {
                if (!(object.item(j) instanceof Text)) continue;
                Text text = (Text)object.item(j);
                System.out.println("WARNING: " + (class$edu$colorado$phet$common$phetcommon$statistics$StatisticsMessageSender == null ? StatisticsMessageSender.class$("edu.colorado.phet.common.phetcommon.statistics.StatisticsMessageSender") : class$edu$colorado$phet$common$phetcommon$statistics$StatisticsMessageSender).getName() + ": " + text.getData());
            }
        }
        NodeList nodeList2 = document.getElementsByTagName("error");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object = (Element)nodeList2.item(i);
            NodeList nodeList3 = object.getChildNodes();
            for (int j = 0; j < nodeList3.getLength(); ++j) {
                if (!(nodeList3.item(j) instanceof Text)) continue;
                Text text = (Text)nodeList3.item(j);
                System.err.println("ERROR: " + (class$edu$colorado$phet$common$phetcommon$statistics$StatisticsMessageSender == null ? StatisticsMessageSender.class$("edu.colorado.phet.common.phetcommon.statistics.StatisticsMessageSender") : class$edu$colorado$phet$common$phetcommon$statistics$StatisticsMessageSender).getName() + ": " + text.getData());
            }
        }
        String string = StatisticsMessageSender.getResponseTag("statistics_message");
        object = StatisticsMessageSender.getAttribute(document, string, "success");
        return ((String)object).equals("true");
    }

    private static String getResponseTag(String string) {
        return string + "_response";
    }

    private static String getAttribute(Document document, String string, String string2) {
        Element element;
        String string3 = null;
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() > 0 && (string3 = (element = (Element)nodeList.item(0)).getAttribute(string2)) != null && string3.length() == 0) {
            string3 = null;
        }
        return string3;
    }
}

