/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.resources.PhetInstallerVersion;
import edu.colorado.phet.common.phetcommon.resources.PhetVersion;
import edu.colorado.phet.common.phetcommon.statistics.StatisticsMessageSender;
import edu.colorado.phet.common.phetcommon.util.logging.USLogger;
import edu.colorado.phet.common.phetcommon.view.util.XMLUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class VersionInfoQuery {
    private final String project;
    private final String sim;
    private final PhetVersion currentSimVersion;
    private final PhetInstallerVersion currentInstallerVersion;
    private final boolean automaticRequest;
    private final ArrayList listeners;
    private final boolean hasSimQuery;
    private final boolean hasInstallerQuery;

    public VersionInfoQuery(String string, String string2, PhetVersion phetVersion, PhetInstallerVersion phetInstallerVersion, boolean bl) {
        this.project = string;
        this.sim = string2;
        this.currentSimVersion = phetVersion;
        this.currentInstallerVersion = phetInstallerVersion;
        this.automaticRequest = bl;
        this.listeners = new ArrayList();
        this.hasSimQuery = string != null && string2 != null;
        this.hasInstallerQuery = phetInstallerVersion != null;
    }

    public VersionInfoQuery(ISimInfo iSimInfo, PhetInstallerVersion phetInstallerVersion, boolean bl) {
        this(iSimInfo.getProjectName(), iSimInfo.getFlavor(), iSimInfo.getVersion(), phetInstallerVersion, bl);
    }

    public VersionInfoQuery(ISimInfo iSimInfo, boolean bl) {
        this(iSimInfo, null, bl);
    }

    public VersionInfoQuery(PhetInstallerVersion phetInstallerVersion, boolean bl) {
        this(null, null, null, phetInstallerVersion, bl);
    }

    public PhetVersion getCurrentSimVersion() {
        return this.currentSimVersion;
    }

    public PhetInstallerVersion getCurrentInstallerVersion() {
        return this.currentInstallerVersion;
    }

    public void send() {
        try {
            Document document = this.buildQueryDocument();
            USLogger.log(this.getClass().getName() + " posting to url=" + "http://phet.colorado.edu/services/phet-info");
            USLogger.log(this.getClass().getName() + " query=\n" + XMLUtils.toString(document));
            HttpURLConnection httpURLConnection = XMLUtils.post("http://phet.colorado.edu/services/phet-info", document);
            Document document2 = XMLUtils.readDocument(httpURLConnection);
            USLogger.log(this.getClass().getName() + " response=\n" + XMLUtils.toString(document2));
            Response response = this.parseResponse(document2, this);
            if (response != null) {
                this.notifyDone(response);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.notifyException(parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            this.notifyException(transformerException);
        }
        catch (UnknownHostException unknownHostException) {
            this.notifyException(unknownHostException);
        }
        catch (IOException iOException) {
            this.notifyException(iOException);
        }
        catch (SAXException sAXException) {
            this.notifyException(sAXException);
        }
    }

    private Document buildQueryDocument() throws ParserConfigurationException {
        Element element;
        String string = this.automaticRequest ? "automatic" : "manual";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element2 = document.createElement("phet_info");
        document.appendChild(element2);
        if (this.hasSimQuery) {
            element = document.createElement("sim_version");
            element.setAttribute("request_version", String.valueOf(1));
            element.setAttribute("project", this.project);
            element.setAttribute("sim", this.sim);
            element.setAttribute("requested_by", string);
            element2.appendChild(element);
        }
        if (this.hasInstallerQuery) {
            element = document.createElement("phet_installer_update");
            element.setAttribute("request_version", String.valueOf(1));
            element.setAttribute("timestamp_seconds", String.valueOf(this.currentInstallerVersion.getTimestamp()));
            element.setAttribute("requested_by", string);
            element2.appendChild(element);
        }
        return document;
    }

    private Response parseResponse(Document document, VersionInfoQuery versionInfoQuery) throws TransformerException {
        Object object;
        NodeList nodeList = document.getElementsByTagName("error");
        if (nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            NodeList nodeList2 = element.getChildNodes();
            Text text = (Text)nodeList2.item(0);
            System.err.println("ERROR: " + StatisticsMessageSender.class.getName() + ": " + text.getData());
            this.notifyException(new VersionInfoQueryException(text.getData()));
            return null;
        }
        NodeList nodeList3 = document.getElementsByTagName("warning");
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            object = (Element)nodeList3.item(i);
            NodeList nodeList4 = object.getChildNodes();
            for (int j = 0; j < nodeList4.getLength(); ++j) {
                if (!(nodeList4.item(j) instanceof Text)) continue;
                Text text = (Text)nodeList4.item(j);
                System.out.println("WARNING: " + (class$edu$colorado$phet$common$phetcommon$statistics$StatisticsMessageSender == null ? VersionInfoQuery.class$("edu.colorado.phet.common.phetcommon.statistics.StatisticsMessageSender") : class$edu$colorado$phet$common$phetcommon$statistics$StatisticsMessageSender).getName() + ": " + text.getData());
            }
        }
        SimResponse simResponse = this.parseSimResponse(document);
        object = this.parseInstallerResponse(document);
        return new Response(versionInfoQuery, simResponse, (InstallerResponse)object);
    }

    private SimResponse parseSimResponse(Document document) {
        SimResponse simResponse = null;
        if (this.hasSimQuery) {
            PhetVersion phetVersion = null;
            long l = 0L;
            String string = "sim_version_response";
            String string2 = VersionInfoQuery.getAttribute(document, string, "version_major");
            String string3 = VersionInfoQuery.getAttribute(document, string, "version_minor");
            String string4 = VersionInfoQuery.getAttribute(document, string, "version_dev");
            String string5 = VersionInfoQuery.getAttribute(document, string, "version_revision");
            String string6 = VersionInfoQuery.getAttribute(document, string, "version_timestamp");
            if (string2 == null || string3 == null || string4 == null || string5 == null || string6 == null) {
                this.notifyException(new VersionInfoQueryException("missing one or more attribututes related to sim version"));
                return null;
            }
            phetVersion = new PhetVersion(string2, string3, string4, string5, string6);
            String string7 = "ask_me_later_duration_days";
            String string8 = VersionInfoQuery.getAttribute(document, string, string7);
            if (string8 == null) {
                this.notifyException(new VersionInfoQueryException(string + " is missing attribute " + string7));
                return null;
            }
            try {
                l = MathUtil.daysToMilliseconds(Long.parseLong(string8));
            }
            catch (NumberFormatException numberFormatException) {
                this.notifyException(new VersionInfoQueryException("expected a number, received " + string8));
                return null;
            }
            simResponse = new SimResponse(this.getCurrentSimVersion(), phetVersion, l);
        }
        return simResponse;
    }

    private InstallerResponse parseInstallerResponse(Document document) {
        InstallerResponse installerResponse = null;
        if (this.hasInstallerQuery) {
            boolean bl = false;
            PhetInstallerVersion phetInstallerVersion = null;
            long l = 0L;
            String string = "phet_installer_update_response";
            String string2 = "recommend_update";
            String string3 = VersionInfoQuery.getAttribute(document, string, string2);
            if (string3 == null) {
                this.notifyException(new VersionInfoQueryException(string + " is missing attribute " + string2));
            }
            bl = Boolean.valueOf(string3);
            string2 = "timestamp_seconds";
            string3 = VersionInfoQuery.getAttribute(document, string, string2);
            if (string3 == null) {
                this.notifyException(new VersionInfoQueryException(string + " is missing attribute " + string2));
                return null;
            }
            try {
                phetInstallerVersion = new PhetInstallerVersion(Long.parseLong(string3));
            }
            catch (NumberFormatException numberFormatException) {
                this.notifyException(new VersionInfoQueryException("expected a number, received " + string3));
                return null;
            }
            string2 = "ask_me_later_duration_days";
            string3 = VersionInfoQuery.getAttribute(document, string, string2);
            if (string3 == null) {
                this.notifyException(new VersionInfoQueryException(string + " is missing attribute " + string2));
                return null;
            }
            try {
                l = MathUtil.daysToMilliseconds(Long.parseLong(string3));
            }
            catch (NumberFormatException numberFormatException) {
                this.notifyException(new VersionInfoQueryException("expected a number, received " + string3));
                return null;
            }
            installerResponse = new InstallerResponse(bl, phetInstallerVersion, l);
        }
        return installerResponse;
    }

    private static String getAttribute(Document document, String string, String string2) {
        Element element;
        String string3 = null;
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() > 0 && (string3 = (element = (Element)nodeList.item(0)).getAttribute(string2)) != null && string3.length() == 0) {
            string3 = null;
        }
        return string3;
    }

    public void addListener(VersionInfoQueryListener versionInfoQueryListener) {
        this.listeners.add(versionInfoQueryListener);
    }

    private void notifyDone(Response response) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((VersionInfoQueryListener)this.listeners.get(i)).done(response);
        }
    }

    private void notifyException(Exception exception) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((VersionInfoQueryListener)this.listeners.get(i)).exception(exception);
        }
    }

    public static class VersionInfoQueryException
    extends Exception {
        public VersionInfoQueryException(String string) {
            super(string);
        }
    }

    public static interface VersionInfoQueryListener {
        public void done(Response var1);

        public void exception(Exception var1);
    }

    public static class InstallerResponse {
        private final boolean isUpdateRecommended;
        private final PhetInstallerVersion version;
        private final long askMeLaterDuration;

        public InstallerResponse(boolean bl, PhetInstallerVersion phetInstallerVersion, long l) {
            this.isUpdateRecommended = bl;
            this.version = phetInstallerVersion;
            this.askMeLaterDuration = l;
        }

        public boolean isUpdateRecommended() {
            return this.isUpdateRecommended;
        }

        public PhetInstallerVersion getVersion() {
            return this.version;
        }

        public long getAskMeLaterDuration() {
            return this.askMeLaterDuration;
        }
    }

    public static class SimResponse {
        private final PhetVersion currentVersion;
        private final PhetVersion version;
        private final long askMeLaterDuration;

        public SimResponse(PhetVersion phetVersion, PhetVersion phetVersion2, long l) {
            this.currentVersion = phetVersion;
            this.version = phetVersion2;
            this.askMeLaterDuration = l;
        }

        public boolean isUpdateRecommended() {
            return this.getVersion().isGreaterThan(this.currentVersion);
        }

        public PhetVersion getVersion() {
            return this.version;
        }

        public long getAskMeLaterDuration() {
            return this.askMeLaterDuration;
        }
    }

    public static class Response {
        private final VersionInfoQuery query;
        private final SimResponse simResponse;
        private final InstallerResponse installerResponse;

        public Response(VersionInfoQuery versionInfoQuery, SimResponse simResponse, InstallerResponse installerResponse) {
            this.query = versionInfoQuery;
            this.simResponse = simResponse;
            this.installerResponse = installerResponse;
        }

        public VersionInfoQuery getQuery() {
            return this.query;
        }

        public SimResponse getSimResponse() {
            return this.simResponse;
        }

        public InstallerResponse getInstallerResponse() {
            return this.installerResponse;
        }
    }
}

