/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.cavendishexperiment;

import edu.colorado.phet.cavendishexperiment.CavendishExperimentModel$;
import edu.colorado.phet.cavendishexperiment.Mass;
import edu.colorado.phet.cavendishexperiment.Spring;
import edu.colorado.phet.cavendishexperiment.Wall;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.colorado.phet.scalacommon.util.Observable;
import edu.colorado.phet.scalacommon.util.Observable$class;
import scala.Function0;
import scala.collection.mutable.ArrayBuffer;

public class CavendishExperimentModel
implements Observable {
    private final ArrayBuffer edu$colorado$phet$scalacommon$util$Observable$$listeners;
    private final double G;
    private final Spring spring;
    private final Mass m2;
    private final Mass m1;
    private final Wall wall;

    public CavendishExperimentModel() {
        Observable$class.$init$(this);
        this.wall = new Wall();
        this.m1 = new Mass(10.0, new Vector2D(0.0, 0.0), "m1");
        this.m2 = new Mass(25.0, new Vector2D(1.0, 0.0), "m2");
        this.spring = new Spring();
        this.m1().addListenerByName(new $anonfun$16(this));
        this.m2().addListenerByName(new $anonfun$17(this));
        this.G = 6.67E-11;
    }

    public void update(double dt) {
        double xDesired = this.wall().maxX() + (double)this.spring().restingLength() + this.getForce().magnitude() / this.spring().k();
        double x = xDesired + this.m1().radius() > this.m2().position().x() - this.m2().radius() ? this.m2().position().x() - this.m2().radius() - this.m1().radius() : xDesired;
        this.m1().position_$eq(new Vector2D(x, 0.0));
    }

    public Vector2D getForce() {
        return this.r().$times(this.G()).$times(this.m1().mass()).$times(this.m2().mass()).$div(Math.pow(this.r().magnitude(), 3.0));
    }

    public double G() {
        return this.G;
    }

    public Vector2D r() {
        return this.rFull();
    }

    public Vector2D rFull() {
        return this.m1().position().$minus(this.m2().position());
    }

    public Spring spring() {
        return this.spring;
    }

    public Mass m2() {
        return this.m2;
    }

    public Mass m1() {
        return this.m1;
    }

    public Wall wall() {
        return this.wall;
    }

    public void addListenerByName(Function0 x$1) {
        Observable$class.addListenerByName(this, x$1);
    }

    public void addListener(Function0 x$1) {
        Observable$class.addListener(this, x$1);
    }

    public void notifyListeners() {
        Observable$class.notifyListeners(this);
    }

    public void edu$colorado$phet$scalacommon$util$Observable$$listeners_$eq(ArrayBuffer x$1) {
        this.edu$colorado$phet$scalacommon$util$Observable$$listeners = x$1;
    }

    public final ArrayBuffer edu$colorado$phet$scalacommon$util$Observable$$listeners() {
        return this.edu$colorado$phet$scalacommon$util$Observable$$listeners;
    }
}

