/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view.meters;

import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import java.awt.Color;
import java.awt.Font;
import java.text.MessageFormat;
import java.text.NumberFormat;

public class TimesTenValueNode
extends HTMLNode {
    private final NumberFormat mantissaFormat;
    private int exponent;
    private final String units;
    private double value;

    public TimesTenValueNode(NumberFormat numberFormat, int n, String string, double d, Font font, Color color) {
        this.setFont(font);
        this.setHTMLColor(color);
        this.mantissaFormat = numberFormat;
        this.exponent = n;
        this.units = string;
        this.value = d;
        this.update();
    }

    public void setValue(double d) {
        if (d != this.value) {
            this.value = d;
            this.update();
        }
    }

    public void setExponent(int n) {
        if (n != this.exponent) {
            this.exponent = n;
            this.update();
        }
    }

    private void update() {
        String string = "0";
        if (this.value != 0.0) {
            double d = this.value / Math.pow(10.0, this.exponent);
            string = MessageFormat.format("<html>{0}x10<sup>{1}</sup></html>", this.mantissaFormat.format(d), this.exponent);
        }
        this.setHTML(MessageFormat.format(CLStrings.PATTERN_VALUE_UNITS, string, this.units));
    }
}

