/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view.meters;

import edu.colorado.phet.capacitorlab.CLImages;
import edu.colorado.phet.capacitorlab.CLPaints;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.drag.WorldLocationDragHandler;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.meter.BarMeter;
import edu.colorado.phet.capacitorlab.view.meters.TimesTenValueNode;
import edu.colorado.phet.capacitorlab.view.meters.ZoomButtonNode;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;

public abstract class BarMeterNode
extends PhetPNode {
    private static final PDimension TRACK_SIZE = new PDimension(50.0, 200.0);
    private static final Color TRACK_FILL_COLOR = Color.WHITE;
    private static final Color TRACK_STROKE_COLOR = Color.BLACK;
    private static final Stroke TRACK_STROKE = new BasicStroke(1.0f);
    private static final Color BAR_STROKE_COLOR = TRACK_STROKE_COLOR;
    private static final Stroke BAR_STROKE = TRACK_STROKE;
    private static final Color TICK_MARK_COLOR = TRACK_STROKE_COLOR;
    private static final Stroke TICK_MARK_STROKE = TRACK_STROKE;
    private static final Font RANGE_LABEL_FONT = new PhetFont(14);
    private static final Color RANGE_LABEL_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new PhetFont(1, 16);
    private static final Color TITLE_COLOR = Color.BLACK;
    private static final PhetFont VALUE_FONT = new PhetFont(16);
    private static final Color VALUE_COLOR = Color.BLACK;
    private static final double OVERLOAD_INDICATOR_WIDTH = 0.75 * TRACK_SIZE.getWidth();
    private final TrackNode trackNode;
    private final BarNode barNode;
    private final TitleNode titleNode;
    private final TimesTenValueNode valueNode;
    private final PowerOfTenRangeLabelNode maxLabelNode;
    private final RangeLabelNode minLabelNode;
    private final OverloadIndicatorNode overloadIndicatorNode;
    private final ZoomButtonNode zoomInButtonNode;
    private final ZoomButtonNode zoomOutButtonNode;
    private final PImage closeButton;
    private final TickMarkNode maxTickMarkNode;
    private final TickMarkNode minTickMarkNode;
    private double value;
    private final Property<Integer> exponentProperty;
    private final Property<Boolean> hasBeenVisibleProperty;

    public BarMeterNode(final BarMeter barMeter, final CLModelViewTransform3D cLModelViewTransform3D, Color color, String string, String string2, int n, String string3) {
        this.value = barMeter.getValue();
        this.exponentProperty = new Property<Integer>(n);
        this.hasBeenVisibleProperty = new Property<Boolean>(barMeter.visibleProperty.get());
        this.trackNode = new TrackNode();
        this.addChild(this.trackNode);
        double d = Math.pow(10.0, n);
        this.barNode = new BarNode(color, d, this.value);
        this.addChild(this.barNode);
        double d2 = BarMeterNode.TRACK_SIZE.height / 10.0;
        for (int i = 0; i < 10; ++i) {
            TickMarkNode tickMarkNode = new TickMarkNode(5.0);
            this.addChild(tickMarkNode);
            double d3 = -5.0;
            tickMarkNode.setOffset(d3, (double)(i + 1) * d2);
        }
        this.maxTickMarkNode = new TickMarkNode(5.0);
        this.addChild(this.maxTickMarkNode);
        this.minTickMarkNode = new TickMarkNode(5.0);
        this.addChild(this.minTickMarkNode);
        this.minLabelNode = new RangeLabelNode("0");
        this.addChild(this.minLabelNode);
        this.maxLabelNode = new PowerOfTenRangeLabelNode(n);
        this.addChild(this.maxLabelNode);
        this.titleNode = new TitleNode(string);
        this.addChild(this.titleNode);
        this.overloadIndicatorNode = new OverloadIndicatorNode(color, d, this.value);
        this.addChild(this.overloadIndicatorNode);
        this.valueNode = new TimesTenValueNode(new DecimalFormat(string2), n, string3, this.value, VALUE_FONT, VALUE_COLOR);
        this.addChild(this.valueNode);
        this.closeButton = new PImage(CLImages.CLOSE_BUTTON);
        this.addChild(this.closeButton);
        this.zoomInButtonNode = new ZoomButtonNode.ZoomInButtonNode();
        this.addChild(this.zoomInButtonNode);
        this.zoomOutButtonNode = new ZoomButtonNode.ZoomOutButtonNode();
        this.addChild(this.zoomOutButtonNode);
        this.updateZoomButtons();
        this.closeButton.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                barMeter.visibleProperty.set(false);
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BarMeterNode.this.updateExponent();
            }
        };
        this.zoomInButtonNode.addActionListener(actionListener);
        this.zoomOutButtonNode.addActionListener(actionListener);
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new WorldLocationDragHandler(barMeter.locationProperty, this, cLModelViewTransform3D));
        this.updateLayout();
        barMeter.addValueObserver(new SimpleObserver(){

            public void update() {
                BarMeterNode.this.setValue(barMeter.getValue());
            }
        });
        barMeter.visibleProperty.addObserver(new SimpleObserver(){

            public void update() {
                BarMeterNode.this.setVisible(barMeter.visibleProperty.get());
            }
        });
        barMeter.locationProperty.addObserver(new SimpleObserver(){

            public void update() {
                BarMeterNode.this.setOffset(cLModelViewTransform3D.modelToView((Point3D)barMeter.locationProperty.get()));
            }
        });
        this.exponentProperty.addObserver(new SimpleObserver(){

            public void update() {
                BarMeterNode.this.handleExponentChanged();
            }
        });
    }

    public void reset() {
        this.exponentProperty.reset();
        this.hasBeenVisibleProperty.reset();
    }

    public void setVisible(boolean bl) {
        if (bl != this.getVisible()) {
            super.setVisible(bl);
            if (bl && !this.hasBeenVisibleProperty.get().booleanValue()) {
                this.hasBeenVisibleProperty.set(true);
                this.updateExponent();
            }
        }
    }

    private void updateLayout() {
        double d = 0.0;
        double d2 = 0.0;
        this.trackNode.setOffset(d, d2);
        this.barNode.setOffset(this.trackNode.getOffset());
        d = -this.maxTickMarkNode.getFullBoundsReference().getWidth();
        d2 = this.trackNode.getYOffset();
        this.maxTickMarkNode.setOffset(d, d2);
        d = -this.minTickMarkNode.getFullBoundsReference().getWidth();
        d2 = this.trackNode.getFullBoundsReference().getMaxY();
        this.minTickMarkNode.setOffset(d, d2);
        d = this.maxTickMarkNode.getFullBoundsReference().getMinX() - this.maxLabelNode.getFullBoundsReference().width - 2.0;
        d2 = this.maxTickMarkNode.getFullBoundsReference().getCenterY() - this.maxLabelNode.getFullBoundsReference().getHeight() / 2.0;
        this.maxLabelNode.setOffset(d, d2);
        d = this.minTickMarkNode.getFullBoundsReference().getMinX() - this.minLabelNode.getFullBoundsReference().width - 2.0;
        d2 = this.minTickMarkNode.getFullBoundsReference().getCenterY() - this.minLabelNode.getFullBoundsReference().getHeight() / 2.0;
        this.minLabelNode.setOffset(d, d2);
        d = this.trackNode.getFullBoundsReference().getCenterX();
        d2 = this.trackNode.getFullBoundsReference().getMinY() - this.overloadIndicatorNode.getFullBoundsReference().getHeight() - 1.0;
        this.overloadIndicatorNode.setOffset(d, d2);
        d = this.trackNode.getFullBoundsReference().getCenterX() - this.titleNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = this.minLabelNode.getFullBoundsReference().getMaxY() + 2.0;
        this.titleNode.setOffset(d, d2);
        d = this.titleNode.getFullBoundsReference().getCenterX() - this.valueNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = this.titleNode.getFullBoundsReference().getMaxY() + 2.0;
        this.valueNode.setOffset(d, d2);
        d = this.trackNode.getFullBoundsReference().getMaxX() + 2.0;
        d2 = this.trackNode.getFullBoundsReference().getMinY();
        this.closeButton.setOffset(d, d2);
        d = this.maxLabelNode.getFullBoundsReference().getMaxX() - this.zoomInButtonNode.getFullBoundsReference().getWidth();
        d2 = this.maxLabelNode.getFullBoundsReference().getMaxY() + 5.0;
        this.zoomInButtonNode.setOffset(d, d2);
        d = this.zoomInButtonNode.getXOffset();
        d2 = this.zoomInButtonNode.getFullBoundsReference().getMaxY() + 1.0;
        this.zoomOutButtonNode.setOffset(d, d2);
    }

    private void updateZoomButtons() {
        double d = this.value / Math.pow(10.0, this.exponentProperty.get().intValue());
        boolean bl = this.value != 0.0 && d < 0.1;
        boolean bl2 = this.value != 0.0 && d > 1.0;
        this.zoomInButtonNode.setEnabled(bl);
        this.zoomOutButtonNode.setEnabled(bl2);
    }

    private void updateExponent() {
        if (this.value != 0.0) {
            int n = 0;
            while (this.value / Math.pow(10.0, n) < 0.1) {
                --n;
            }
            this.exponentProperty.set(n);
        }
    }

    protected void setValue(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("value must be >= 0 : " + d);
        }
        if (d != this.value) {
            this.value = d;
            this.barNode.setValue(d);
            this.overloadIndicatorNode.setValue(d);
            this.valueNode.setValue(d);
            this.updateLayout();
            this.updateZoomButtons();
        }
    }

    private void handleExponentChanged() {
        int n = this.exponentProperty.get();
        double d = Math.pow(10.0, n);
        this.barNode.setMaxValue(d);
        this.overloadIndicatorNode.setMaxValue(d);
        this.maxLabelNode.setExponent(n);
        this.valueNode.setExponent(n);
        this.updateLayout();
        this.updateZoomButtons();
    }

    protected void setBarColor(Color color) {
        this.barNode.setPaint(color);
        this.overloadIndicatorNode.setArrowFillColor(color);
    }

    private static class BarNode
    extends PPath {
        private double value;
        private double maxValue;
        private final Rectangle2D rectangle;

        public BarNode(Color color, double d, double d2) {
            this.value = d2;
            this.maxValue = d;
            this.rectangle = new Rectangle2D.Double(0.0, 0.0, TRACK_SIZE.width, TRACK_SIZE.height);
            this.setPathTo(this.rectangle);
            this.setPaint(color);
            this.setStrokePaint(BAR_STROKE_COLOR);
            this.setStroke(BAR_STROKE);
            this.update();
        }

        public void setValue(double d) {
            if (d != this.value) {
                this.value = d;
                this.update();
            }
        }

        public void setMaxValue(double d) {
            if (d != this.maxValue) {
                this.maxValue = d;
                this.update();
            }
        }

        private void update() {
            double d = Math.min(1.0, Math.abs(this.value) / this.maxValue);
            double d2 = (1.0 - d) * TRACK_SIZE.height;
            double d3 = TRACK_SIZE.height - d2;
            this.rectangle.setRect(0.0, d2, TRACK_SIZE.width, d3);
            this.setPathTo(this.rectangle);
        }
    }

    public static class CapacitanceMeterNode
    extends BarMeterNode {
        public CapacitanceMeterNode(BarMeter.CapacitanceMeter capacitanceMeter, CLModelViewTransform3D cLModelViewTransform3D, String string) {
            super(capacitanceMeter, cLModelViewTransform3D, CLPaints.CAPACITANCE, string, "0.00", -12, CLStrings.FARADS);
        }
    }

    private static class OverloadIndicatorNode
    extends PComposite {
        private final ArrowNode arrowNode;
        private double value;
        private double maxValue;

        public OverloadIndicatorNode(Color color, double d, double d2) {
            this.value = d2;
            this.maxValue = d;
            Point2D.Double double_ = new Point2D.Double(0.0, 15.0);
            Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
            double d3 = 9.0;
            double d4 = OVERLOAD_INDICATOR_WIDTH;
            double d5 = d4 / 2.0;
            this.arrowNode = new ArrowNode(double_, double_2, d3, d4, d5);
            this.arrowNode.setPaint(color);
            this.addChild(this.arrowNode);
            this.update();
        }

        public void setValue(double d) {
            if (d != this.value) {
                this.value = d;
                this.update();
            }
        }

        public void setMaxValue(double d) {
            if (d != this.maxValue) {
                this.maxValue = d;
                this.update();
            }
        }

        public void setArrowFillColor(Color color) {
            this.arrowNode.setPaint(color);
        }

        private void update() {
            this.setVisible(this.value > this.maxValue);
        }
    }

    public static class PlateChargeMeterNode
    extends BarMeterNode {
        public PlateChargeMeterNode(BarMeter.PlateChargeMeter plateChargeMeter, CLModelViewTransform3D cLModelViewTransform3D, String string) {
            super(plateChargeMeter, cLModelViewTransform3D, CLPaints.POSITIVE_CHARGE, string, "0.00", -13, CLStrings.COULOMBS);
        }

        protected void setValue(double d) {
            super.setValue(Math.abs(d));
            this.setBarColor(d >= 0.0 ? CLPaints.POSITIVE_CHARGE : CLPaints.NEGATIVE_CHARGE);
        }
    }

    private static class PowerOfTenRangeLabelNode
    extends RangeLabelNode {
        public PowerOfTenRangeLabelNode(int n) {
            super(MessageFormat.format("<html>10<sup>{0}</sup></html>", n));
        }

        public void setExponent(int n) {
            this.setHTML(MessageFormat.format("<html>10<sup>{0}</sup></html>", n));
        }
    }

    private static class RangeLabelNode
    extends HTMLNode {
        public RangeLabelNode(String string) {
            this();
            this.setHTML(string);
        }

        protected RangeLabelNode() {
            this.setHTMLColor(RANGE_LABEL_COLOR);
            this.setFont(RANGE_LABEL_FONT);
        }
    }

    public static class StoredEnergyMeterNode
    extends BarMeterNode {
        public StoredEnergyMeterNode(BarMeter.StoredEnergyMeter storedEnergyMeter, CLModelViewTransform3D cLModelViewTransform3D, String string) {
            super(storedEnergyMeter, cLModelViewTransform3D, CLPaints.STORED_ENERGY, string, "0.00", -13, CLStrings.JOULES);
        }
    }

    private static class TickMarkNode
    extends PPath {
        public TickMarkNode(double d) {
            super(new Line2D.Double(0.0, 0.0, d, 0.0));
            this.setStrokePaint(TICK_MARK_COLOR);
            this.setStroke(TICK_MARK_STROKE);
        }
    }

    private static class TitleNode
    extends PText {
        public TitleNode(String string) {
            super(string);
            this.setTextPaint(TITLE_COLOR);
            this.setFont(TITLE_FONT);
        }
    }

    private static class TrackNode
    extends PPath {
        public TrackNode() {
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, TRACK_SIZE.width, TRACK_SIZE.height));
            this.setPaint(TRACK_FILL_COLOR);
            this.setStrokePaint(TRACK_STROKE_COLOR);
            this.setStroke(TRACK_STROKE);
        }
    }
}

