/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.view.BoxNode;
import edu.colorado.phet.common.phetcommon.math.Dimension3D;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

public class TransparentBoxNode
extends BoxNode {
    private static final Stroke BACK_STROKE = new BasicStroke(1.0f);
    private static final Color BACK_STROKE_COLOR = Color.GRAY;
    private static final Color BACK_FILL_COLOR = new Color(0, 0, 0, 0);
    private final PPath bottomNode;
    private final PPath backNode;
    private final PPath leftSideNode;

    public TransparentBoxNode(CLModelViewTransform3D cLModelViewTransform3D, Color color, Dimension3D dimension3D) {
        super(cLModelViewTransform3D, color, dimension3D);
        this.bottomNode = new PhetPPath(this.getShapeCreator().createBottomFace(dimension3D), BACK_FILL_COLOR, BACK_STROKE, BACK_STROKE_COLOR);
        this.backNode = new PhetPPath(this.getShapeCreator().createBackFace(dimension3D), BACK_FILL_COLOR, BACK_STROKE, BACK_STROKE_COLOR);
        this.leftSideNode = new PhetPPath(this.getShapeCreator().createLeftSideFace(dimension3D), BACK_FILL_COLOR, BACK_STROKE, BACK_STROKE_COLOR);
        this.addChild(this.bottomNode);
        this.addChild(this.backNode);
        this.addChild(this.leftSideNode);
        this.bottomNode.moveToBack();
        this.backNode.moveToBack();
        this.leftSideNode.moveToBack();
    }

    protected void updateShapes() {
        super.updateShapes();
        this.bottomNode.setPathTo(this.getShapeCreator().createBottomFace(this.getBoxSize()));
        this.backNode.setPathTo(this.getShapeCreator().createBackFace(this.getBoxSize()));
        this.leftSideNode.setPathTo(this.getShapeCreator().createLeftSideFace(this.getBoxSize()));
    }

    public void setTransparent(boolean bl) {
        this.setTransparency(bl ? 0.5f : 1.0f);
    }
}

