/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.shapes.BoxShapeCreator;
import edu.colorado.phet.common.phetcommon.math.Dimension3D;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

public abstract class BoxNode
extends PhetPNode {
    private static final Stroke STROKE = new BasicStroke(1.0f);
    private static final Color STROKE_COLOR = Color.BLACK;
    private final BoxShapeCreator shapeCreator;
    private final PPath topNode;
    private final PPath frontNode;
    private final PPath rightSideNode;
    private Dimension3D size;

    public BoxNode(CLModelViewTransform3D cLModelViewTransform3D, Color color, Dimension3D dimension3D) {
        this.shapeCreator = new BoxShapeCreator(cLModelViewTransform3D);
        this.size = new Dimension3D(dimension3D);
        this.topNode = new PhetPPath(this.shapeCreator.createTopFace(dimension3D), this.getTopColor(color), STROKE, STROKE_COLOR);
        this.frontNode = new PhetPPath(this.shapeCreator.createFrontFace(dimension3D), this.getFrontColor(color), STROKE, STROKE_COLOR);
        this.rightSideNode = new PhetPPath(this.shapeCreator.createRightSideFace(dimension3D), this.getSideColor(color), STROKE, STROKE_COLOR);
        this.addChild(this.topNode);
        this.addChild(this.frontNode);
        this.addChild(this.rightSideNode);
    }

    protected BoxShapeCreator getShapeCreator() {
        return this.shapeCreator;
    }

    public void setBoxSize(Dimension3D dimension3D) {
        if (!dimension3D.equals(this.size)) {
            this.size = new Dimension3D(dimension3D);
            this.updateShapes();
        }
    }

    protected Dimension3D getBoxSize() {
        return this.size;
    }

    public void setColor(Color color) {
        this.topNode.setPaint(this.getTopColor(color));
        this.frontNode.setPaint(this.getFrontColor(color));
        this.rightSideNode.setPaint(this.getSideColor(color));
    }

    protected void updateShapes() {
        this.topNode.setPathTo(this.shapeCreator.createTopFace(this.size));
        this.frontNode.setPathTo(this.shapeCreator.createFrontFace(this.size));
        this.rightSideNode.setPathTo(this.shapeCreator.createRightSideFace(this.size));
    }

    private Color getTopColor(Color color) {
        return color;
    }

    private Color getFrontColor(Color color) {
        return this.getDarkerColor(this.getTopColor(color));
    }

    private Color getSideColor(Color color) {
        return this.getDarkerColor(this.getDarkerColor(color));
    }

    private Color getDarkerColor(Color color) {
        Color color2 = color.darker();
        return new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), color.getAlpha());
    }
}

