/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.shapes;

import edu.colorado.phet.capacitorlab.model.Battery;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Polarity;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class BatteryShapeCreator {
    private final Battery battery;
    private final CLModelViewTransform3D mvt;

    public BatteryShapeCreator(Battery battery, CLModelViewTransform3D cLModelViewTransform3D) {
        this.battery = battery;
        this.mvt = cLModelViewTransform3D;
    }

    public Shape createBodyShape() {
        double d = this.battery.getBodySizeReference().getWidth();
        double d2 = this.battery.getBodySizeReference().getHeight();
        double d3 = this.battery.getLocationReference().getX() - d / 2.0;
        double d4 = this.battery.getLocationReference().getY() - d2 / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d, d2);
        return this.mvt.modelToView(double_);
    }

    public Shape createTopTerminalShape() {
        if (this.battery.getPolarity() == Polarity.POSITIVE) {
            return this.createPositiveTerminalShape(this.battery.getLocationReference());
        }
        return this.createNegativeTerminalShape(this.battery.getLocationReference());
    }

    private Shape createPositiveTerminalShape(Point3D point3D) {
        double d = this.battery.getPositiveTerminalEllipseSize().getWidth();
        double d2 = this.battery.getPositiveTerminalEllipseSize().getHeight();
        double d3 = point3D.getX() - d / 2.0;
        double d4 = point3D.getY() + this.battery.getTopTerminalYOffset() - d2 / 2.0;
        Ellipse2D.Double double_ = new Ellipse2D.Double(d3, d4, d, d2);
        double d5 = this.battery.getPositiveTerminalEllipseSize().getWidth();
        double d6 = this.battery.getPositiveTerminalEllipseSize().getHeight();
        double d7 = point3D.getX() - d5 / 2.0;
        double d8 = point3D.getY() + this.battery.getTopTerminalYOffset() - d6 / 2.0 + this.battery.getPositiveTerminalCylinderHeight();
        Ellipse2D.Double double_2 = new Ellipse2D.Double(d7, d8, d5, d6);
        d2 = this.battery.getPositiveTerminalEllipseSize().getWidth();
        d3 = this.battery.getPositiveTerminalCylinderHeight();
        d4 = point3D.getX() - d2 / 2.0;
        double d9 = point3D.getY() + this.battery.getTopTerminalYOffset();
        Rectangle2D.Double double_3 = new Rectangle2D.Double(d4, d9, d2, d3);
        Shape shape = ShapeUtils.add(double_, double_3, double_2);
        return this.mvt.modelToView(shape);
    }

    private Shape createNegativeTerminalShape(Point3D point3D) {
        double d = this.battery.getNegativeTerminalSizeReference().getWidth();
        double d2 = this.battery.getNegativeTerminalSizeReference().getHeight();
        double d3 = point3D.getX() - d / 2.0;
        double d4 = point3D.getY() + this.battery.getTopTerminalYOffset() - d2 / 2.0;
        Ellipse2D.Double double_ = new Ellipse2D.Double(d3, d4, d, d2);
        return this.mvt.modelToView(double_);
    }
}

