/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.module;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.CLGlobalProperties;
import edu.colorado.phet.capacitorlab.CLPaints;
import edu.colorado.phet.capacitorlab.model.CLModel;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.DielectricChargeView;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Dimension2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CLCanvas
extends PhetPCanvas {
    private final Property<Boolean> plateChargesVisibleProperty = new Property<Boolean>(true);
    private final Property<Boolean> eFieldVisibleProperty = new Property<Boolean>(false);
    private final Property<DielectricChargeView> dielectricChargeViewProperty = new Property<DielectricChargeView>(CLConstants.DIELECTRIC_CHARGE_VIEW);
    private final CLModel model;
    private final CLModelViewTransform3D mvt;
    private final CLGlobalProperties globalProperties;
    private final PNode rootNode;

    public CLCanvas(CLModel cLModel, CLModelViewTransform3D cLModelViewTransform3D, CLGlobalProperties cLGlobalProperties) {
        super(CLConstants.CANVAS_RENDERING_SIZE);
        this.setBackground(CLPaints.CANVAS_BACKGROUND);
        this.model = cLModel;
        this.mvt = cLModelViewTransform3D;
        this.globalProperties = cLGlobalProperties;
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
    }

    public void reset() {
        this.plateChargesVisibleProperty.reset();
        this.eFieldVisibleProperty.reset();
        this.dielectricChargeViewProperty.reset();
    }

    protected void addChild(PNode pNode) {
        this.rootNode.addChild(pNode);
    }

    protected CLGlobalProperties getGlobalProperties() {
        return this.globalProperties;
    }

    public Property<Boolean> getPlateChargesVisibleProperty() {
        return this.plateChargesVisibleProperty;
    }

    public Property<Boolean> getEFieldVisibleProperty() {
        return this.eFieldVisibleProperty;
    }

    public Property<DielectricChargeView> getDielectricChargeViewProperty() {
        return this.dielectricChargeViewProperty;
    }

    @Override
    protected void updateLayout() {
        super.updateLayout();
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() <= 0.0 || dimension2D.getHeight() <= 0.0) {
            return;
        }
        Point3D point3D = this.mvt.viewToModelDelta(dimension2D.getWidth(), dimension2D.getHeight());
        this.model.getWorldBounds().setBounds(0.0, 0.0, point3D.getX(), point3D.getY());
    }
}

