/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.wire;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.wire.WireSegment;
import edu.colorado.phet.capacitorlab.shapes.WireShapeCreator;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import java.awt.Shape;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wire {
    private final ArrayList<WireSegment> segments;
    private final SimpleObserver segmentObserver;
    private final double thickness;
    private final WireShapeCreator shapeCreator;
    private final Property<Shape> shapeProperty;

    public Wire(CLModelViewTransform3D cLModelViewTransform3D, double d, ArrayList<WireSegment> arrayList) {
        assert (arrayList != null);
        assert (d > 0.0);
        this.segments = new ArrayList<WireSegment>(arrayList);
        this.thickness = d;
        this.shapeCreator = new WireShapeCreator(this, cLModelViewTransform3D);
        this.shapeProperty = new Property<Shape>(this.createShape());
        this.segmentObserver = new SimpleObserver(){

            public void update() {
                Wire.this.setShape(Wire.this.createShape());
            }
        };
        for (WireSegment wireSegment : arrayList) {
            Wire.addSegmentObserver(wireSegment, this.segmentObserver);
        }
    }

    protected Wire(CLModelViewTransform3D cLModelViewTransform3D, double d) {
        this(cLModelViewTransform3D, d, new ArrayList<WireSegment>());
    }

    protected void addSegment(WireSegment wireSegment) {
        this.segments.add(wireSegment);
        Wire.addSegmentObserver(wireSegment, this.segmentObserver);
    }

    private static void addSegmentObserver(WireSegment wireSegment, SimpleObserver simpleObserver) {
        wireSegment.startPointProperty.addObserver(simpleObserver);
        wireSegment.endPointProperty.addObserver(simpleObserver);
    }

    public double getThickness() {
        return this.thickness;
    }

    public ArrayList<WireSegment> getSegments() {
        return new ArrayList<WireSegment>(this.segments);
    }

    public void addShapeObserver(SimpleObserver simpleObserver) {
        this.shapeProperty.addObserver(simpleObserver);
    }

    public Shape getShape() {
        return this.shapeProperty.get();
    }

    protected void setShape(Shape shape) {
        this.shapeProperty.set(shape);
    }

    public boolean intersects(Shape shape) {
        return ShapeUtils.intersects(this.shapeProperty.get(), shape);
    }

    protected Shape createShape() {
        return this.shapeCreator.createWireShape();
    }

    protected double getCornerOffset() {
        return this.shapeCreator.getCornerOffset();
    }

    protected double getEndOffset() {
        return this.shapeCreator.getEndOffset();
    }
}

