/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.meter;

import edu.colorado.phet.capacitorlab.model.WorldBounds;
import edu.colorado.phet.capacitorlab.model.WorldLocationProperty;
import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BarMeter {
    public final WorldLocationProperty locationProperty;
    public final Property<Boolean> visibleProperty;
    private final Property<Double> valueProperty;
    private final Function1<ICircuit, Double> valueFunction;
    private ICircuit circuit;
    private ICircuit.CircuitChangeListener circuitChangeListener;

    public BarMeter(ICircuit iCircuit, WorldBounds worldBounds, Point3D point3D, boolean bl, Function1<ICircuit, Double> function1) {
        this.circuit = iCircuit;
        this.locationProperty = new WorldLocationProperty(worldBounds, point3D);
        this.visibleProperty = new Property<Boolean>(bl);
        this.valueProperty = new Property<Double>(function1.apply(iCircuit));
        this.valueFunction = function1;
        this.circuitChangeListener = new ICircuit.CircuitChangeListener(){

            public void circuitChanged() {
                BarMeter.this.updateValue();
            }
        };
        iCircuit.addCircuitChangeListener(this.circuitChangeListener);
    }

    public void reset() {
        this.locationProperty.reset();
        this.visibleProperty.reset();
        this.valueProperty.reset();
    }

    public void setCircuit(ICircuit iCircuit) {
        if (iCircuit != this.circuit) {
            this.circuit.removeCircuitChangeListener(this.circuitChangeListener);
            this.circuit = iCircuit;
            this.circuit.addCircuitChangeListener(this.circuitChangeListener);
            this.updateValue();
        }
    }

    public void addValueObserver(SimpleObserver simpleObserver) {
        this.valueProperty.addObserver(simpleObserver);
    }

    public double getValue() {
        return this.valueProperty.get();
    }

    private void updateValue() {
        this.valueProperty.set(this.valueFunction.apply(this.circuit));
    }

    public static class CapacitanceMeter
    extends BarMeter {
        public CapacitanceMeter(ICircuit iCircuit, WorldBounds worldBounds, Point3D point3D, boolean bl) {
            super(iCircuit, worldBounds, point3D, bl, new Function1<ICircuit, Double>(){

                @Override
                public Double apply(ICircuit iCircuit) {
                    return iCircuit.getTotalCapacitance();
                }
            });
        }
    }

    public static class PlateChargeMeter
    extends BarMeter {
        public PlateChargeMeter(ICircuit iCircuit, WorldBounds worldBounds, Point3D point3D, boolean bl) {
            super(iCircuit, worldBounds, point3D, bl, new Function1<ICircuit, Double>(){

                @Override
                public Double apply(ICircuit iCircuit) {
                    return iCircuit.getTotalCharge();
                }
            });
        }
    }

    public static class StoredEnergyMeter
    extends BarMeter {
        public StoredEnergyMeter(ICircuit iCircuit, WorldBounds worldBounds, Point3D point3D, boolean bl) {
            super(iCircuit, worldBounds, point3D, bl, new Function1<ICircuit, Double>(){

                @Override
                public Double apply(ICircuit iCircuit) {
                    return iCircuit.getStoredEnergy();
                }
            });
        }
    }
}

