/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Polarity;
import edu.colorado.phet.capacitorlab.shapes.BatteryShapeCreator;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Shape;
import java.awt.geom.Dimension2D;

public class Battery {
    private static final PDimension BODY_SIZE = new PDimension(0.0065, 0.01425);
    private static final PDimension POSITIVE_TERMINAL_ELLIPSE_SIZE = new PDimension(0.0025, 5.0E-4);
    private static final double POSITIVE_TERMINAL_Y_OFFSET = -(BODY_SIZE.getHeight() / 2.0) + 5.05E-4;
    private static final PDimension NEGATIVE_TERMINAL_ELLIPSE_SIZE = new PDimension(0.0035, 9.0E-4);
    private static final double NEGATIVE_TERMINAL_Y_OFFSET = -(BODY_SIZE.getHeight() / 2.0) + 0.00105;
    private final Point3D location;
    private final BatteryShapeCreator shapeCreator;
    private final Property<Double> voltageProperty;
    private final Property<Polarity> polarityProperty;

    public Battery(Point3D point3D, double d, CLModelViewTransform3D cLModelViewTransform3D) {
        this.location = new Point3D.Double(point3D);
        this.voltageProperty = new Property<Double>(d);
        this.polarityProperty = new Property<Polarity>(Battery.getPolarity(d));
        this.shapeCreator = new BatteryShapeCreator(this, cLModelViewTransform3D);
        this.voltageProperty.addObserver(new SimpleObserver(){

            public void update() {
                Battery.this.setPolarity(Battery.getPolarity(Battery.this.getVoltage()));
            }
        });
    }

    public void reset() {
        this.voltageProperty.reset();
    }

    public Point3D getLocationReference() {
        return this.location;
    }

    public double getX() {
        return this.location.getX();
    }

    public double getY() {
        return this.location.getY();
    }

    public void setVoltage(double d) {
        this.voltageProperty.set(d);
    }

    public double getVoltage() {
        return this.voltageProperty.get();
    }

    public void addVoltageObserver(SimpleObserver simpleObserver, boolean bl) {
        this.voltageProperty.addObserver(simpleObserver, bl);
    }

    public void addVoltageObserver(SimpleObserver simpleObserver) {
        this.addVoltageObserver(simpleObserver, true);
    }

    private void setPolarity(Polarity polarity) {
        this.polarityProperty.set(polarity);
    }

    public Polarity getPolarity() {
        return this.polarityProperty.get();
    }

    private static Polarity getPolarity(double d) {
        return d >= 0.0 ? Polarity.POSITIVE : Polarity.NEGATIVE;
    }

    public void addPolarityObserver(SimpleObserver simpleObserver) {
        this.polarityProperty.addObserver(simpleObserver);
    }

    public boolean intersectsTopTerminal(Shape shape) {
        return ShapeUtils.intersects(this.shapeCreator.createTopTerminalShape(), shape);
    }

    public boolean intersectsBottomTerminal(Shape shape) {
        return false;
    }

    public BatteryShapeCreator getShapeCreator() {
        return this.shapeCreator;
    }

    public Dimension2D getBodySizeReference() {
        return BODY_SIZE;
    }

    public double getPositiveTerminalCylinderHeight() {
        return 9.0E-4;
    }

    public Dimension2D getPositiveTerminalEllipseSize() {
        return POSITIVE_TERMINAL_ELLIPSE_SIZE;
    }

    public Dimension2D getNegativeTerminalSizeReference() {
        return NEGATIVE_TERMINAL_ELLIPSE_SIZE;
    }

    public double getTopTerminalYOffset() {
        if (this.getPolarity() == Polarity.POSITIVE) {
            return POSITIVE_TERMINAL_Y_OFFSET;
        }
        return NEGATIVE_TERMINAL_Y_OFFSET;
    }

    public double getBottomTerminalYOffset() {
        return BODY_SIZE.getHeight() / 2.0;
    }
}

