/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.drag;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

class PlateSeparationDragHandler
extends PDragSequenceEventHandler {
    private final PNode dragNode;
    private final Capacitor capacitor;
    private final CLModelViewTransform3D mvt;
    private final DoubleRange valueRange;
    private double clickYOffset;

    public PlateSeparationDragHandler(PNode pNode, Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, DoubleRange doubleRange) {
        this.dragNode = pNode;
        this.capacitor = capacitor;
        this.mvt = cLModelViewTransform3D;
        this.valueRange = new DoubleRange(doubleRange);
    }

    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
        Point2D point2D2 = this.mvt.modelToView(0.0, -(this.capacitor.getPlateSeparation() / 2.0), 0.0);
        this.clickYOffset = point2D.getY() - point2D2.getY();
    }

    protected void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
        double d = point2D.getY() - this.clickYOffset;
        double d2 = MathUtil.clamp(2.0 * this.mvt.viewToModelDelta(0.0, -d).getY(), this.valueRange);
        this.capacitor.setPlateSeparation(d2);
    }
}

